/*
 * Decompiled with CFR 0.152.
 */
package off.szymon.vMessage.libs.configurate.yaml;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import off.szymon.vMessage.libs.configurate.CommentedConfigurationNode;
import off.szymon.vMessage.libs.configurate.ConfigurationNode;
import off.szymon.vMessage.libs.configurate.ConfigurationOptions;
import off.szymon.vMessage.libs.configurate.RepresentationHint;
import off.szymon.vMessage.libs.configurate.yaml.NodeStyle;
import off.szymon.vMessage.libs.configurate.yaml.ScalarStyle;
import off.szymon.vMessage.libs.configurate.yaml.YamlConfigurationLoader;
import off.szymon.vMessage.libs.configurate.yaml.internal.snakeyaml.LoaderOptions;
import off.szymon.vMessage.libs.configurate.yaml.internal.snakeyaml.comments.CommentLine;
import off.szymon.vMessage.libs.configurate.yaml.internal.snakeyaml.constructor.Constructor;
import off.szymon.vMessage.libs.configurate.yaml.internal.snakeyaml.nodes.MappingNode;
import off.szymon.vMessage.libs.configurate.yaml.internal.snakeyaml.nodes.Node;
import off.szymon.vMessage.libs.configurate.yaml.internal.snakeyaml.nodes.NodeId;
import off.szymon.vMessage.libs.configurate.yaml.internal.snakeyaml.nodes.NodeTuple;
import off.szymon.vMessage.libs.configurate.yaml.internal.snakeyaml.nodes.ScalarNode;
import off.szymon.vMessage.libs.configurate.yaml.internal.snakeyaml.nodes.SequenceNode;
import off.szymon.vMessage.libs.configurate.yaml.internal.snakeyaml.nodes.Tag;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

class YamlConstructor
extends Constructor {
    private static final Pattern LINE_BREAK_PATTERN = Pattern.compile("\\R");
    @Nullable ConfigurationOptions options;

    YamlConstructor(LoaderOptions loadingConfig) {
        super(loadingConfig);
    }

    @Override
    @EnsuresNonNull(value={"options"})
    public Object getSingleData(Class<?> type2) {
        if (this.options == null) {
            throw new IllegalStateException("options must be set before calling load!");
        }
        return super.getSingleData(type2);
    }

    @Override
    protected Object constructObjectNoCheck(Node yamlNode) {
        CommentedConfigurationNode node = CommentedConfigurationNode.root(this.options);
        if (yamlNode.getTag() == Tag.COMMENT) {
            return node;
        }
        if (yamlNode.getNodeId() == NodeId.mapping) {
            node.raw(Collections.emptyMap());
            MappingNode mapping = (MappingNode)yamlNode;
            if (mapping.getFlowStyle() != null) {
                node.hint((RepresentationHint)YamlConfigurationLoader.NODE_STYLE, (Object)NodeStyle.fromSnakeYaml(mapping.getFlowStyle()));
            }
            for (NodeTuple tuple : mapping.getValue()) {
                ConfigurationNode keyNode = (ConfigurationNode)this.constructObject(tuple.getKeyNode());
                Node valueNode = tuple.getValueNode();
                ((CommentedConfigurationNode)((CommentedConfigurationNode)node.node(new Object[]{keyNode.raw()})).from((ConfigurationNode)this.constructObject(valueNode))).comment(YamlConstructor.commentFor(tuple.getKeyNode().getBlockComments()));
            }
            return node.comment(YamlConstructor.commentFor(yamlNode.getBlockComments()));
        }
        Object raw = super.constructObjectNoCheck(yamlNode);
        if (raw instanceof Collection) {
            node.raw(Collections.emptyList());
            if (((SequenceNode)yamlNode).getFlowStyle() != null) {
                node.hint((RepresentationHint)YamlConfigurationLoader.NODE_STYLE, (Object)NodeStyle.fromSnakeYaml(((SequenceNode)yamlNode).getFlowStyle()));
            }
            for (Object value : (Collection)raw) {
                ((CommentedConfigurationNode)node.appendListNode()).from((ConfigurationNode)value);
            }
        } else {
            if (yamlNode instanceof ScalarNode) {
                node.hint((RepresentationHint)YamlConfigurationLoader.SCALAR_STYLE, (Object)ScalarStyle.fromSnakeYaml(((ScalarNode)yamlNode).getScalarStyle()));
            }
            node.raw(raw);
        }
        return node.comment(YamlConstructor.commentFor(yamlNode.getBlockComments()));
    }

    private static @Nullable String commentFor(@Nullable List<CommentLine> commentLines) {
        if (commentLines == null || commentLines.isEmpty()) {
            return null;
        }
        StringBuilder outputBuilder = new StringBuilder();
        for (CommentLine line : commentLines) {
            String lineStripped;
            if (outputBuilder.length() > 0) {
                outputBuilder.append("\n");
            }
            if (!(lineStripped = YamlConstructor.removeLineBreaksForLine(line.getValue())).isEmpty() && lineStripped.charAt(0) == ' ') {
                outputBuilder.append(lineStripped, 1, lineStripped.length());
                continue;
            }
            outputBuilder.append(lineStripped);
        }
        return outputBuilder.toString();
    }

    private static String removeLineBreaksForLine(String line) {
        return LINE_BREAK_PATTERN.matcher(line).replaceAll("");
    }
}

