/*
 * Decompiled with CFR 0.152.
 */
package off.szymon.vMessage;

import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ServerConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.kyori.adventure.text.minimessage.MiniMessage;
import off.szymon.vMessage.VMessagePlugin;
import off.szymon.vMessage.compatibility.LuckPermsCompatibilityProvider;
import off.szymon.vMessage.config.ConfigManager;
import off.szymon.vMessage.libs.configurate.CommentedConfigurationNode;

public class Broadcaster {
    private final HashMap<String, String> serverAliases = new HashMap();
    private final LuckPermsCompatibilityProvider lp;
    private final HashMap<String, String> metaPlaceholders;

    public Broadcaster() {
        this.reloadAliases();
        this.lp = VMessagePlugin.get().getLuckPermsCompatibilityProvider();
        this.metaPlaceholders = new HashMap();
        this.reloadMetaPlaceholders();
    }

    public void message(Player player, String message) {
        if (!ConfigManager.get().getConfig().getMessages().getChat().getEnabled()) {
            return;
        }
        String msg = ConfigManager.get().getConfig().getMessages().getChat().getFormat();
        msg = msg.replace("%player%", player.getUsername()).replace("%message%", this.escapeMiniMessage(message)).replace("%server%", this.parseAlias(((ServerConnection)player.getCurrentServer().get()).getServerInfo().getName()));
        if (this.lp != null) {
            LuckPermsCompatibilityProvider.PlayerData data2 = this.lp.getMetaData(player);
            msg = msg.replace("%suffix%", Optional.ofNullable(data2.metaData().getSuffix()).orElse("")).replace("%prefix%", Optional.ofNullable(data2.metaData().getPrefix()).orElse(""));
            for (Map.Entry<String, String> entry : this.metaPlaceholders.entrySet()) {
                msg = msg.replace(entry.getKey(), Optional.ofNullable(data2.metaData().getMetaValue(entry.getValue())).orElse(""));
            }
        }
        VMessagePlugin.get().getServer().sendMessage(MiniMessage.miniMessage().deserialize((Object)msg));
    }

    public void join(Player player) {
        if (!ConfigManager.get().getConfig().getMessages().getJoin().getEnabled()) {
            return;
        }
        if (player.hasPermission("vmessage.silent.join")) {
            VMessagePlugin.get().getLogger().info("{} has silent join permission, not broadcasting join message", (Object)player.getUsername());
            return;
        }
        String msg = ConfigManager.get().getConfig().getMessages().getJoin().getFormat();
        msg = msg.replace("%player%", player.getUsername()).replace("%server%", this.parseAlias(((ServerConnection)player.getCurrentServer().get()).getServerInfo().getName()));
        if (this.lp != null) {
            LuckPermsCompatibilityProvider.PlayerData data2 = this.lp.getMetaData(player);
            msg = msg.replace("%suffix%", Optional.ofNullable(data2.metaData().getSuffix()).orElse("")).replace("%prefix%", Optional.ofNullable(data2.metaData().getPrefix()).orElse(""));
            for (Map.Entry<String, String> entry : this.metaPlaceholders.entrySet()) {
                msg = msg.replace(entry.getKey(), Optional.ofNullable(data2.metaData().getMetaValue(entry.getValue())).orElse(""));
            }
        }
        VMessagePlugin.get().getServer().sendMessage(MiniMessage.miniMessage().deserialize((Object)msg));
    }

    public void leave(Player player) {
        if (!ConfigManager.get().getConfig().getMessages().getLeave().getEnabled()) {
            return;
        }
        if (player.hasPermission("vmessage.silent.leave")) {
            VMessagePlugin.get().getLogger().info("{} has silent leave permission, not broadcasting leave message", (Object)player.getUsername());
            return;
        }
        String msg = ConfigManager.get().getConfig().getMessages().getLeave().getFormat();
        String serverName = player.getCurrentServer().map(server -> server.getServerInfo().getName()).map(this::parseAlias).orElse(null);
        if (serverName == null) {
            return;
        }
        msg = msg.replace("%player%", player.getUsername()).replace("%server%", serverName);
        if (this.lp != null) {
            LuckPermsCompatibilityProvider.PlayerData data2 = this.lp.getMetaData(player);
            msg = msg.replace("%suffix%", Optional.ofNullable(data2.metaData().getSuffix()).orElse("")).replace("%prefix%", Optional.ofNullable(data2.metaData().getPrefix()).orElse(""));
            for (Map.Entry<String, String> entry : this.metaPlaceholders.entrySet()) {
                msg = msg.replace(entry.getKey(), Optional.ofNullable(data2.metaData().getMetaValue(entry.getValue())).orElse(""));
            }
        }
        VMessagePlugin.get().getServer().sendMessage(MiniMessage.miniMessage().deserialize((Object)msg));
    }

    public void change(Player player, String oldServer) {
        if (!ConfigManager.get().getConfig().getMessages().getChange().getEnabled()) {
            return;
        }
        if (player.hasPermission("vmessage.silent.change")) {
            VMessagePlugin.get().getLogger().info("{} has silent change permission, not broadcasting change message", (Object)player.getUsername());
            return;
        }
        String msg = ConfigManager.get().getConfig().getMessages().getChange().getFormat();
        msg = msg.replace("%player%", player.getUsername()).replace("%new_server%", this.parseAlias(((ServerConnection)player.getCurrentServer().get()).getServerInfo().getName())).replace("%old_server%", this.parseAlias(oldServer));
        if (this.lp != null) {
            LuckPermsCompatibilityProvider.PlayerData data2 = this.lp.getMetaData(player);
            msg = msg.replace("%suffix%", Optional.ofNullable(data2.metaData().getSuffix()).orElse("")).replace("%prefix%", Optional.ofNullable(data2.metaData().getPrefix()).orElse(""));
            for (Map.Entry<String, String> entry : this.metaPlaceholders.entrySet()) {
                msg = msg.replace(entry.getKey(), Optional.ofNullable(data2.metaData().getMetaValue(entry.getValue())).orElse(""));
            }
        }
        VMessagePlugin.get().getServer().sendMessage(MiniMessage.miniMessage().deserialize((Object)msg));
    }

    public void reload() {
        this.reloadAliases();
        this.reloadMetaPlaceholders();
    }

    public void reloadAliases() {
        this.serverAliases.clear();
        Set aliases = ConfigManager.get().getNode("serverAliases").childrenMap().entrySet();
        for (Map.Entry entry : aliases) {
            this.serverAliases.put(entry.getKey().toString(), ((CommentedConfigurationNode)entry.getValue()).toString());
        }
    }

    public void reloadMetaPlaceholders() {
        this.metaPlaceholders.clear();
        if (this.lp != null) {
            Set metas = ConfigManager.get().getNode("luckPermsMeta").childrenMap().entrySet();
            for (Map.Entry entry : metas) {
                this.metaPlaceholders.put("&" + entry.getKey().toString() + "&", ((CommentedConfigurationNode)entry.getValue()).toString());
            }
        }
    }

    public void broadcast(String message) {
        String msg = ConfigManager.get().getConfig().getCommands().getBroadcast().getFormat();
        msg = msg.replace("%message%", message);
        VMessagePlugin.get().getServer().sendMessage(MiniMessage.miniMessage().deserialize((Object)msg));
    }

    public String parseAlias(String serverName) {
        for (Map.Entry<String, String> entry : this.serverAliases.entrySet()) {
            if (!serverName.equalsIgnoreCase(entry.getKey())) continue;
            String output = entry.getValue();
            return output;
        }
        return serverName;
    }

    public HashMap<String, String> getMetaPlaceholders() {
        return this.metaPlaceholders;
    }

    private String escapeMiniMessage(String input) {
        return ConfigManager.get().getConfig().getMessages().getChat().getAllowMiniMessage() ? input : MiniMessage.miniMessage().escapeTags(input);
    }
}

