/*
 * Decompiled with CFR 0.152.
 */
package off.szymon.vMessage.libs.configurate;

import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.CheckReturnValue;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import off.szymon.vMessage.libs.configurate.AutoValue_ConfigurationOptions;
import off.szymon.vMessage.libs.configurate.serialize.TypeSerializerCollection;
import off.szymon.vMessage.libs.configurate.util.MapFactories;
import off.szymon.vMessage.libs.configurate.util.MapFactory;
import off.szymon.vMessage.libs.configurate.util.Types;
import off.szymon.vMessage.libs.configurate.util.UnmodifiableCollections;
import org.checkerframework.checker.nullness.qual.Nullable;

@CheckReturnValue
@AutoValue
public abstract class ConfigurationOptions {
    ConfigurationOptions() {
    }

    public static ConfigurationOptions defaults() {
        return Lazy.DEFAULTS;
    }

    public abstract MapFactory mapFactory();

    public ConfigurationOptions mapFactory(MapFactory mapFactory) {
        Objects.requireNonNull(mapFactory, "mapFactory");
        if (this.mapFactory() == mapFactory) {
            return this;
        }
        return new AutoValue_ConfigurationOptions(mapFactory, this.header(), this.serializers(), this.nativeTypes(), this.shouldCopyDefaults(), this.implicitInitialization());
    }

    public abstract @Nullable String header();

    public ConfigurationOptions header(@Nullable String header) {
        if (Objects.equals(this.header(), header)) {
            return this;
        }
        return new AutoValue_ConfigurationOptions(this.mapFactory(), header, this.serializers(), this.nativeTypes(), this.shouldCopyDefaults(), this.implicitInitialization());
    }

    public abstract TypeSerializerCollection serializers();

    public ConfigurationOptions serializers(TypeSerializerCollection serializers) {
        Objects.requireNonNull(serializers, "serializers");
        if (this.serializers().equals(serializers)) {
            return this;
        }
        return new AutoValue_ConfigurationOptions(this.mapFactory(), this.header(), serializers, this.nativeTypes(), this.shouldCopyDefaults(), this.implicitInitialization());
    }

    public final ConfigurationOptions serializers(Consumer<TypeSerializerCollection.Builder> serializerBuilder) {
        Objects.requireNonNull(serializerBuilder, "serializerBuilder");
        TypeSerializerCollection.Builder builder = this.serializers().childBuilder();
        serializerBuilder.accept(builder);
        return this.serializers(builder.build());
    }

    abstract @Nullable Set<Class<?>> nativeTypes();

    public ConfigurationOptions nativeTypes(@Nullable Set<Class<?>> nativeTypes) {
        if (Objects.equals(this.nativeTypes(), nativeTypes)) {
            return this;
        }
        return new AutoValue_ConfigurationOptions(this.mapFactory(), this.header(), this.serializers(), nativeTypes == null ? null : UnmodifiableCollections.copyOf(nativeTypes), this.shouldCopyDefaults(), this.implicitInitialization());
    }

    public final boolean acceptsType(Class<?> type2) {
        Objects.requireNonNull(type2, "type");
        @Nullable Set<Class<?>> nativeTypes = this.nativeTypes();
        if (nativeTypes == null) {
            return true;
        }
        if (nativeTypes.contains(type2)) {
            return true;
        }
        if (type2.isPrimitive() && nativeTypes.contains(Types.box(type2))) {
            return true;
        }
        Type unboxed = Types.unbox(type2);
        if (unboxed != type2 && nativeTypes.contains(unboxed)) {
            return true;
        }
        for (Class<?> clazz : nativeTypes) {
            if (!clazz.isAssignableFrom(type2)) continue;
            return true;
        }
        return false;
    }

    public abstract boolean shouldCopyDefaults();

    public ConfigurationOptions shouldCopyDefaults(boolean shouldCopyDefaults) {
        if (this.shouldCopyDefaults() == shouldCopyDefaults) {
            return this;
        }
        return new AutoValue_ConfigurationOptions(this.mapFactory(), this.header(), this.serializers(), this.nativeTypes(), shouldCopyDefaults, this.implicitInitialization());
    }

    public abstract boolean implicitInitialization();

    public ConfigurationOptions implicitInitialization(boolean implicitInitialization) {
        if (this.implicitInitialization() == implicitInitialization) {
            return this;
        }
        return new AutoValue_ConfigurationOptions(this.mapFactory(), this.header(), this.serializers(), this.nativeTypes(), this.shouldCopyDefaults(), implicitInitialization);
    }

    static class Lazy {
        static final ConfigurationOptions DEFAULTS = new AutoValue_ConfigurationOptions(MapFactories.insertionOrdered(), null, TypeSerializerCollection.defaults(), null, true, true);

        Lazy() {
        }
    }
}

