/*
 * Decompiled with CFR 0.152.
 */
package off.szymon.vMessage.libs.configurate.reactive;

import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import off.szymon.vMessage.libs.configurate.reactive.CachedPublisher;
import off.szymon.vMessage.libs.configurate.reactive.Disposable;
import off.szymon.vMessage.libs.configurate.reactive.ExecutePublisher;
import off.szymon.vMessage.libs.configurate.reactive.MappedProcessor;
import off.szymon.vMessage.libs.configurate.reactive.Subscriber;
import off.szymon.vMessage.libs.configurate.reactive.TransactionFailedException;
import off.szymon.vMessage.libs.configurate.util.CheckedFunction;
import off.szymon.vMessage.libs.configurate.util.CheckedSupplier;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface Publisher<V> {
    public static <V, E extends Exception> Publisher<V> execute(CheckedSupplier<V, E> action) {
        return Publisher.execute(action, ForkJoinPool.commonPool());
    }

    public static <V, E extends Exception> Publisher<V> execute(CheckedSupplier<V, E> action, Executor executor2) {
        return new ExecutePublisher<V>(Objects.requireNonNull(action, "action"), Objects.requireNonNull(executor2, "executor"));
    }

    public Disposable subscribe(Subscriber<? super V> var1);

    public boolean hasSubscribers();

    default public <R> Publisher<R> map(CheckedFunction<? super V, ? extends R, TransactionFailedException> mapper) {
        return new MappedProcessor<V, R>(mapper, this);
    }

    default public Cached<V> cache() {
        return this.cache(null);
    }

    default public Cached<V> cache(@Nullable V initialValue) {
        return new CachedPublisher<V>(this, initialValue);
    }

    public Executor executor();

    public static interface Cached<V>
    extends Publisher<V> {
        public V get();

        public void submit(V var1);
    }
}

