/*
 * Decompiled with CFR 0.152.
 */
package off.szymon.vMessage.libs.configurate.serialize;

import java.lang.reflect.AnnotatedType;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import off.szymon.vMessage.libs.configurate.serialize.PatternFlags;
import off.szymon.vMessage.libs.configurate.serialize.ScalarSerializer;
import off.szymon.vMessage.libs.configurate.serialize.SerializationException;
import org.checkerframework.checker.nullness.qual.Nullable;

final class PatternSerializer
extends ScalarSerializer.Annotated<Pattern> {
    PatternSerializer() {
        super(Pattern.class);
    }

    @Override
    public Pattern deserialize(AnnotatedType type2, Object obj) throws SerializationException {
        try {
            @Nullable PatternFlags flags = type2.getAnnotation(PatternFlags.class);
            if (flags != null) {
                return Pattern.compile(obj.toString(), flags.value());
            }
            return Pattern.compile(obj.toString());
        }
        catch (PatternSyntaxException ex) {
            throw new SerializationException(ex);
        }
    }

    @Override
    public Object serialize(Pattern item, Predicate<Class<?>> typeSupported) {
        return item.pattern();
    }
}

