/*
 * Decompiled with CFR 0.152.
 */
package off.szymon.vMessage.libs.configurate.transformation;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import off.szymon.vMessage.libs.configurate.ConfigurateException;
import off.szymon.vMessage.libs.configurate.ConfigurationNode;
import off.szymon.vMessage.libs.configurate.NodePath;
import off.szymon.vMessage.libs.configurate.transformation.ConfigurationTransformation;
import off.szymon.vMessage.libs.configurate.transformation.MoveStrategy;
import off.szymon.vMessage.libs.configurate.transformation.MutableNodePath;
import off.szymon.vMessage.libs.configurate.transformation.TransformAction;
import org.checkerframework.checker.nullness.qual.Nullable;

final class SingleConfigurationTransformation
implements ConfigurationTransformation {
    private final MoveStrategy strategy;
    private final Map<NodePath, TransformAction> actions;
    private final ThreadLocal<MutableNodePath> sharedPath = ThreadLocal.withInitial(MutableNodePath::new);

    SingleConfigurationTransformation(Map<NodePath, TransformAction> actions, MoveStrategy strategy) {
        this.actions = actions;
        this.strategy = strategy;
    }

    @Override
    public void apply(ConfigurationNode node) throws ConfigurateException {
        @Nullable ConfigurateException thrown = null;
        for (Map.Entry<NodePath, TransformAction> ent : this.actions.entrySet()) {
            try {
                this.applySingleAction(node, ent.getKey().array(), 0, node, ent.getValue());
            }
            catch (ConfigurateException ex) {
                if (thrown == null) {
                    thrown = ex;
                    continue;
                }
                thrown.addSuppressed(ex);
            }
        }
        if (thrown != null) {
            throw thrown;
        }
    }

    private void applySingleAction(ConfigurationNode start, Object[] path, int startIdx, ConfigurationNode node, TransformAction action) throws ConfigurateException {
        ConfigurateException thrown = null;
        for (int i2 = startIdx; i2 < path.length; ++i2) {
            if (path[i2] == WILDCARD_OBJECT) {
                if (node.isList()) {
                    List<? extends ConfigurationNode> children2 = node.childrenList();
                    for (int di = 0; di < children2.size(); ++di) {
                        path[i2] = di;
                        try {
                            this.applySingleAction(start, path, i2 + 1, children2.get(di), action);
                            continue;
                        }
                        catch (ConfigurateException ex) {
                            if (thrown == null) {
                                thrown = ex;
                                continue;
                            }
                            thrown.addSuppressed(ex);
                        }
                    }
                    path[i2] = WILDCARD_OBJECT;
                } else if (node.isMap()) {
                    for (Map.Entry<Object, ? extends ConfigurationNode> ent : node.childrenMap().entrySet()) {
                        path[i2] = ent.getKey();
                        try {
                            this.applySingleAction(start, path, i2 + 1, ent.getValue(), action);
                        }
                        catch (ConfigurateException ex) {
                            if (thrown == null) {
                                thrown = ex;
                                continue;
                            }
                            thrown.addSuppressed(ex);
                        }
                    }
                    path[i2] = WILDCARD_OBJECT;
                } else {
                    return;
                }
                return;
            }
            if (!(node = node.node(path[i2])).virtual()) continue;
            return;
        }
        MutableNodePath nodePath = this.sharedPath.get();
        nodePath.arr = path;
        Object @Nullable [] transformedPath = action.visitPath(nodePath, node);
        if (transformedPath != null && !Arrays.equals(path, transformedPath)) {
            this.strategy.move(node, start.node(transformedPath));
            node.raw(null);
        }
    }
}

