/*
 * Decompiled with CFR 0.152.
 */
package off.szymon.vMessage;

import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ServerConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.cacheddata.CachedMetaData;
import off.szymon.vMessage.Config;
import off.szymon.vMessage.VMessagePlugin;
import org.simpleyaml.configuration.ConfigurationSection;

public class Broadcaster {
    private final HashMap<String, String> serverAliases = new HashMap();
    private final LuckPerms lp;
    private final HashMap<String, String> metaPlaceholders;

    public Broadcaster() {
        ConfigurationSection metas;
        ConfigurationSection aliases = Config.getYaml().getConfigurationSection("ServerAliases");
        if (aliases != null) {
            for (String key : aliases.getKeys(false)) {
                this.serverAliases.put(key, aliases.getString(key));
            }
        }
        this.lp = VMessagePlugin.getInstance().getLuckPerms();
        this.metaPlaceholders = new HashMap();
        if (this.lp != null && (metas = Config.getYaml().getConfigurationSection("LuckPermsMeta")) != null) {
            for (String key : metas.getKeys(false)) {
                this.metaPlaceholders.put("&" + key + "&", metas.getString(key));
            }
        }
    }

    public void message(Player player, String message) {
        if (!Config.getYaml().getBoolean("messages.chat.enabled")) {
            return;
        }
        String msg = Config.getString("messages.chat.format");
        msg = msg.replace("%player%", player.getUsername()).replace("%message%", message).replace("%server%", this.parseAlias(((ServerConnection)player.getCurrentServer().get()).getServerInfo().getName()));
        if (this.lp != null) {
            CachedMetaData data = this.lp.getPlayerAdapter(Player.class).getMetaData((Object)player);
            msg = msg.replace("%suffix%", Optional.ofNullable(data.getSuffix()).orElse("")).replace("%prefix%", Optional.ofNullable(data.getPrefix()).orElse(""));
            for (Map.Entry<String, String> entry : this.metaPlaceholders.entrySet()) {
                msg = msg.replace(entry.getKey(), Optional.ofNullable(data.getMetaValue(entry.getValue())).orElse(""));
            }
        }
        VMessagePlugin.getInstance().getServer().sendMessage(MiniMessage.miniMessage().deserialize((Object)msg));
    }

    public void join(Player player) {
        if (!Config.getYaml().getBoolean("messages.join.enabled")) {
            return;
        }
        String msg = Config.getString("messages.join.format");
        msg = msg.replace("%player%", player.getUsername()).replace("%server%", this.parseAlias(((ServerConnection)player.getCurrentServer().get()).getServerInfo().getName()));
        if (this.lp != null) {
            CachedMetaData data = this.lp.getPlayerAdapter(Player.class).getMetaData((Object)player);
            msg = msg.replace("%suffix%", Optional.ofNullable(data.getSuffix()).orElse("")).replace("%prefix%", Optional.ofNullable(data.getPrefix()).orElse(""));
            for (Map.Entry<String, String> entry : this.metaPlaceholders.entrySet()) {
                msg = msg.replace(entry.getKey(), Optional.ofNullable(data.getMetaValue(entry.getValue())).orElse(""));
            }
        }
        VMessagePlugin.getInstance().getServer().sendMessage(MiniMessage.miniMessage().deserialize((Object)msg));
    }

    public void leave(Player player) {
        if (!Config.getYaml().getBoolean("messages.leave.enabled")) {
            return;
        }
        String msg = Config.getString("messages.leave.format");
        String serverName = player.getCurrentServer().map(server -> server.getServerInfo().getName()).map(this::parseAlias).orElse(null);
        if (serverName == null) {
            return;
        }
        msg = msg.replace("%player%", player.getUsername()).replace("%server%", serverName);
        if (this.lp != null) {
            CachedMetaData data = this.lp.getPlayerAdapter(Player.class).getMetaData((Object)player);
            msg = msg.replace("%suffix%", Optional.ofNullable(data.getSuffix()).orElse("")).replace("%prefix%", Optional.ofNullable(data.getPrefix()).orElse(""));
            for (Map.Entry<String, String> entry : this.metaPlaceholders.entrySet()) {
                msg = msg.replace(entry.getKey(), Optional.ofNullable(data.getMetaValue(entry.getValue())).orElse(""));
            }
        }
        VMessagePlugin.getInstance().getServer().sendMessage(MiniMessage.miniMessage().deserialize((Object)msg));
    }

    public void change(Player player, String oldServer) {
        if (!Config.getYaml().getBoolean("messages.change.enabled")) {
            return;
        }
        String msg = Config.getString("messages.change.format");
        msg = msg.replace("%player%", player.getUsername()).replace("%new_server%", this.parseAlias(((ServerConnection)player.getCurrentServer().get()).getServerInfo().getName())).replace("%old_server%", this.parseAlias(oldServer));
        if (this.lp != null) {
            CachedMetaData data = this.lp.getPlayerAdapter(Player.class).getMetaData((Object)player);
            msg = msg.replace("%suffix%", Optional.ofNullable(data.getSuffix()).orElse("")).replace("%prefix%", Optional.ofNullable(data.getPrefix()).orElse(""));
            for (Map.Entry<String, String> entry : this.metaPlaceholders.entrySet()) {
                msg = msg.replace(entry.getKey(), Optional.ofNullable(data.getMetaValue(entry.getValue())).orElse(""));
            }
        }
        VMessagePlugin.getInstance().getServer().sendMessage(MiniMessage.miniMessage().deserialize((Object)msg));
    }

    public void reload() {
        ConfigurationSection metas;
        this.serverAliases.clear();
        ConfigurationSection aliases = Config.getYaml().getConfigurationSection("ServerAliases");
        if (aliases != null) {
            for (String key : aliases.getKeys(false)) {
                this.serverAliases.put(key, aliases.getString(key));
            }
        }
        this.metaPlaceholders.clear();
        if (this.lp != null && (metas = Config.getYaml().getConfigurationSection("LuckPermsMeta")) != null) {
            for (String key : metas.getKeys(false)) {
                this.metaPlaceholders.put("&" + key + "&", metas.getString(key));
            }
        }
    }

    public void broadcast(String message) {
        if (!Config.getYaml().getBoolean("commands.broadcast.enabled")) {
            return;
        }
        String msg = Config.getString("commands.broadcast.format");
        msg = msg.replace("%message%", message);
        VMessagePlugin.getInstance().getServer().sendMessage(MiniMessage.miniMessage().deserialize((Object)msg));
    }

    public String parseAlias(String serverName) {
        for (Map.Entry<String, String> entry : this.serverAliases.entrySet()) {
            if (!serverName.equalsIgnoreCase(entry.getKey())) continue;
            String output = entry.getValue();
            return output;
        }
        return serverName;
    }

    public HashMap<String, String> getMetaPlaceholders() {
        return this.metaPlaceholders;
    }
}

