/*
 * Decompiled with CFR 0.152.
 */
package off.szymon.vMessage;

import com.google.inject.Inject;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.plugin.Dependency;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.PluginContainer;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.ProxyServer;
import java.io.File;
import java.nio.file.Path;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import off.szymon.vMessage.Broadcaster;
import off.szymon.vMessage.Config;
import off.szymon.vMessage.Listener;
import off.szymon.vMessage.cmd.CommandRegisterer;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import space.arim.libertybans.api.LibertyBans;
import space.arim.omnibus.Omnibus;
import space.arim.omnibus.OmnibusProvider;

@Plugin(id="vmessage", name="vMessage", version="1.3.0", description="The #1 plugin for velocity message syncing", authors={"SzymON_OFF"}, dependencies={@Dependency(id="signedvelocity"), @Dependency(id="luckperms", optional=true), @Dependency(id="libertybans", optional=true)})
public class VMessagePlugin {
    private static VMessagePlugin instance;
    private final ProxyServer server;
    private final Logger logger;
    private final File dataFolder;
    private final PluginContainer plugin;
    private final String name;
    private LuckPerms lp;
    private LibertyBans lb;
    private Broadcaster broadcaster;

    @Inject
    public VMessagePlugin(ProxyServer server, Logger logger, @DataDirectory Path dataFolder, PluginContainer plugin) {
        instance = this;
        this.server = server;
        this.logger = logger;
        this.dataFolder = new File(dataFolder.toFile().getParentFile(), this.getClass().getAnnotation(Plugin.class).name());
        this.plugin = plugin;
        this.name = this.getClass().getAnnotation(Plugin.class).name();
        this.onLoad();
    }

    @Subscribe
    public void onProxyInitialization(ProxyInitializeEvent event) {
        this.onEnable();
    }

    @Subscribe
    public void onProxyShutdown(ProxyShutdownEvent event) {
        this.onDisable();
    }

    public void onLoad() {
        System.out.println(this.name + " loaded.");
    }

    public void onEnable() {
        Config.setup();
        if (this.server.getPluginManager().isLoaded("luckperms")) {
            this.logger.info("LuckPerms detected, attempting to hook into it...");
            try {
                this.lp = LuckPermsProvider.get();
                this.logger.info("Successfully hooked into LuckPerms");
            }
            catch (Exception e) {
                this.lp = null;
                this.logger.error("Failed to hook into LuckPerms, disabling support");
            }
        } else {
            this.logger.info("LuckPerms not detected, disabling support");
            this.lp = null;
        }
        if (this.server.getPluginManager().isLoaded("libertybans")) {
            this.logger.info("LibertyBans detected, attempting to hook into it...");
            try {
                Omnibus omnibus = OmnibusProvider.getOmnibus();
                this.lb = (LibertyBans)omnibus.getRegistry().getProvider(LibertyBans.class).orElseThrow();
                this.logger.info("Successfully hooked into LibertyBans");
            }
            catch (Exception e) {
                this.lb = null;
                this.logger.error("Failed to hook into LibertyBans, disabling support");
            }
        } else {
            this.logger.info("LibertyBans not detected, disabling support");
            this.lb = null;
        }
        this.broadcaster = new Broadcaster();
        this.server.getEventManager().register((Object)this, (Object)new Listener());
        CommandRegisterer.registerCommands();
    }

    public void onDisable() {
        System.out.println(this.name + " disabled");
    }

    public ProxyServer getServer() {
        return this.server;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public File getDataFolder() {
        return this.dataFolder;
    }

    public static VMessagePlugin getInstance() {
        return instance;
    }

    @Nullable
    public LuckPerms getLuckPerms() {
        return this.lp;
    }

    @Nullable
    public LibertyBans getLibertyBans() {
        return this.lb;
    }

    public Broadcaster getBroadcaster() {
        return this.broadcaster;
    }

    public PluginContainer getPlugin() {
        return this.plugin;
    }
}

