/*
 * Decompiled with CFR 0.152.
 */
package off.szymon.vMessage.cmd;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.velocitypowered.api.command.BrigadierCommand;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ServerConnection;
import java.util.Optional;
import net.kyori.adventure.text.minimessage.MiniMessage;
import off.szymon.vMessage.VMessagePlugin;
import off.szymon.vMessage.config.ConfigManager;

public class VMessageCommand {
    public BrigadierCommand createCommand() {
        return new BrigadierCommand((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"vmessage").requires(src -> src.hasPermission("vmessage.command"))).executes(ctx -> {
            ((CommandSource)ctx.getSource()).sendMessage(MiniMessage.miniMessage().deserialize((Object)"<#00ffff>vMessage</#00ffff> by <#00ffff>%s</#00ffff>\nVersion: <#00ffff>%s</#00ffff>".formatted(String.join((CharSequence)",", VMessagePlugin.get().getPlugin().getDescription().getAuthors()), VMessagePlugin.get().getPlugin().getDescription().getVersion().get())));
            return 1;
        })).then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"help").requires(src -> src.hasPermission("vmessage.command.help"))).executes(ctx -> {
            ((CommandSource)ctx.getSource()).sendMessage(MiniMessage.miniMessage().deserialize((Object)"<#00ffff>vMessage</#00ffff> Help:\n<#00ffff>/vmessage say <player> <message></#00ffff> - Sends a message as a player\n<#00ffff>/vmessage fake <join/leave/change> [player] [old-server]</#00ffff> - Sends a fake join/leave/change message\n<#00ffff>/vmessage reload</#00ffff> - Reload the config\n<#00ffff>/vmessage help</#00ffff> - Show this help message\n<#00ffff>/vmessage</#00ffff> - Show the plugin version and author"));
            return 1;
        }))).then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"reload").requires(src -> src.hasPermission("vmessage.command.reload"))).executes(ctx -> {
            ConfigManager.get().load();
            VMessagePlugin.get().getBroadcaster().reload();
            ((CommandSource)ctx.getSource()).sendMessage(MiniMessage.miniMessage().deserialize((Object)"<#00ffff>vMessage</#00ffff> config reloaded!"));
            return 1;
        }))).then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"say").requires(src -> src.hasPermission("vmessage.command.say"))).then(RequiredArgumentBuilder.argument((String)"player", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> {
            VMessagePlugin.get().getServer().getAllPlayers().stream().map(Player::getUsername).filter(name -> name.toLowerCase().startsWith(builder.getRemainingLowerCase())).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            return builder.buildFuture();
        }).then(RequiredArgumentBuilder.argument((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            String playerName = StringArgumentType.getString((CommandContext)ctx, (String)"player");
            String message = StringArgumentType.getString((CommandContext)ctx, (String)"message");
            Optional target = VMessagePlugin.get().getServer().getPlayer(playerName);
            if (target.isEmpty()) {
                ((CommandSource)ctx.getSource()).sendMessage(MiniMessage.miniMessage().deserialize((Object)"<red>Player not found."));
                return 1;
            }
            VMessagePlugin.get().getBroadcaster().message((Player)target.get(), message);
            return 1;
        }))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"fake").requires(src -> src.hasPermission("vmessage.command.fake"))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"join").requires(src -> src.hasPermission("vmessage.command.fake.join"))).executes(ctx -> {
            Player player;
            Player player2 = player = ctx.getSource() instanceof Player ? (Player)ctx.getSource() : null;
            if (player == null) {
                ((CommandSource)ctx.getSource()).sendMessage(MiniMessage.miniMessage().deserialize((Object)"<red>You must be a player to use this command."));
                return 1;
            }
            VMessagePlugin.get().getBroadcaster().join(player);
            ((CommandSource)ctx.getSource()).sendMessage(MiniMessage.miniMessage().deserialize((Object)("<green>Fake join message sent for " + player.getUsername() + ".")));
            return 1;
        })).then(RequiredArgumentBuilder.argument((String)"player", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> {
            VMessagePlugin.get().getServer().getAllPlayers().stream().map(Player::getUsername).filter(name -> name.toLowerCase().startsWith(builder.getRemainingLowerCase())).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            return builder.buildFuture();
        }).executes(ctx -> {
            String playerName = StringArgumentType.getString((CommandContext)ctx, (String)"player");
            Optional target = VMessagePlugin.get().getServer().getPlayer(playerName);
            if (target.isEmpty()) {
                ((CommandSource)ctx.getSource()).sendMessage(MiniMessage.miniMessage().deserialize((Object)("<red>Player " + playerName + " not found.")));
                return 1;
            }
            VMessagePlugin.get().getBroadcaster().join((Player)target.get());
            ((CommandSource)ctx.getSource()).sendMessage(MiniMessage.miniMessage().deserialize((Object)("<green>Fake join message sent for " + ((Player)target.get()).getUsername() + ".")));
            return 1;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"leave").requires(src -> src.hasPermission("vmessage.command.fake.leave"))).executes(ctx -> {
            Player player;
            Player player2 = player = ctx.getSource() instanceof Player ? (Player)ctx.getSource() : null;
            if (player == null) {
                ((CommandSource)ctx.getSource()).sendMessage(MiniMessage.miniMessage().deserialize((Object)"<red>You must be a player to use this command."));
                return 1;
            }
            VMessagePlugin.get().getBroadcaster().leave(player);
            ((CommandSource)ctx.getSource()).sendMessage(MiniMessage.miniMessage().deserialize((Object)("<green>Fake leave message sent for " + player.getUsername() + ".")));
            return 1;
        })).then(RequiredArgumentBuilder.argument((String)"player", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> {
            VMessagePlugin.get().getServer().getAllPlayers().stream().map(Player::getUsername).filter(name -> name.toLowerCase().startsWith(builder.getRemainingLowerCase())).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            return builder.buildFuture();
        }).executes(ctx -> {
            String playerName = StringArgumentType.getString((CommandContext)ctx, (String)"player");
            Optional target = VMessagePlugin.get().getServer().getPlayer(playerName);
            if (target.isEmpty()) {
                ((CommandSource)ctx.getSource()).sendMessage(MiniMessage.miniMessage().deserialize((Object)("<red>Player " + playerName + " not found.")));
                return 1;
            }
            VMessagePlugin.get().getBroadcaster().leave((Player)target.get());
            ((CommandSource)ctx.getSource()).sendMessage(MiniMessage.miniMessage().deserialize((Object)("<green>Fake leave message sent for " + ((Player)target.get()).getUsername() + ".")));
            return 1;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"change").requires(src -> src.hasPermission("vmessage.command.fake.change"))).executes(ctx -> {
            Player player;
            Player player2 = player = ctx.getSource() instanceof Player ? (Player)ctx.getSource() : null;
            if (player == null) {
                ((CommandSource)ctx.getSource()).sendMessage(MiniMessage.miniMessage().deserialize((Object)"<red>You must be a player to use this command."));
                return 1;
            }
            VMessagePlugin.get().getBroadcaster().change(player, ((ServerConnection)player.getCurrentServer().get()).getServerInfo().getName());
            ((CommandSource)ctx.getSource()).sendMessage(MiniMessage.miniMessage().deserialize((Object)("<green>Fake change message sent for " + player.getUsername() + ".")));
            return 1;
        })).then(RequiredArgumentBuilder.argument((String)"player", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> {
            VMessagePlugin.get().getServer().getAllPlayers().stream().map(Player::getUsername).filter(name -> name.toLowerCase().startsWith(builder.getRemainingLowerCase())).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            return builder.buildFuture();
        }).then(RequiredArgumentBuilder.argument((String)"old-server", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            String playerName = StringArgumentType.getString((CommandContext)ctx, (String)"player");
            String oldServer = StringArgumentType.getString((CommandContext)ctx, (String)"old-server");
            Optional target = VMessagePlugin.get().getServer().getPlayer(playerName);
            if (target.isEmpty()) {
                ((CommandSource)ctx.getSource()).sendMessage(MiniMessage.miniMessage().deserialize((Object)("<red>Player " + playerName + " not found.")));
                return 1;
            }
            VMessagePlugin.get().getBroadcaster().change((Player)target.get(), oldServer);
            ((CommandSource)ctx.getSource()).sendMessage(MiniMessage.miniMessage().deserialize((Object)("<green>Fake change message sent for " + ((Player)target.get()).getUsername() + ".")));
            return 1;
        }))))));
    }
}

