/*
 * Decompiled with CFR 0.152.
 */
package off.szymon.vMessage.compatibility.mute;

import com.velocitypowered.api.proxy.Player;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import off.szymon.vMessage.VMessagePlugin;
import off.szymon.vMessage.compatibility.mute.MutePluginCompatibilityProvider;
import space.arim.libertybans.api.ConsoleOperator;
import space.arim.libertybans.api.LibertyBans;
import space.arim.libertybans.api.Operator;
import space.arim.libertybans.api.PlayerOperator;
import space.arim.libertybans.api.PunishmentType;
import space.arim.libertybans.api.punish.Punishment;
import space.arim.libertybans.api.select.SelectionByApplicability;
import space.arim.libertybans.api.select.SelectionByApplicabilityBuilder;
import space.arim.omnibus.Omnibus;
import space.arim.omnibus.OmnibusProvider;

public class LibertyBansCompatibilityProvider
implements MutePluginCompatibilityProvider {
    private final LibertyBans lb;

    public LibertyBansCompatibilityProvider() {
        Omnibus omnibus = OmnibusProvider.getOmnibus();
        this.lb = (LibertyBans)omnibus.getRegistry().getProvider(LibertyBans.class).orElseThrow();
    }

    @Override
    public CompletableFuture<Boolean> isMuted(Player player) {
        return this.getPunishment(player).thenApply(punishmentOpt -> {
            Punishment punishment = punishmentOpt.orElse(null);
            return punishment != null && !punishment.isExpired();
        });
    }

    @Override
    public CompletableFuture<MutePluginCompatibilityProvider.Mute> getMute(Player player) {
        return this.getPunishment(player).thenApply(punishmentOpt -> {
            String moderator;
            Punishment punishment = punishmentOpt.orElse(null);
            if (punishment == null) {
                return null;
            }
            String playerName = player.getUsername();
            String reason = punishment.getReason() != null ? punishment.getReason() : "No reason specified";
            Operator operator = punishment.getOperator();
            if (operator instanceof PlayerOperator) {
                PlayerOperator playerOp = (PlayerOperator)operator;
                Player p = VMessagePlugin.get().getServer().getPlayer(playerOp.getUUID()).orElse(null);
                moderator = p != null ? p.getUsername() : "Unknown Player";
            } else {
                moderator = operator instanceof ConsoleOperator ? "Console" : "Unknown";
            }
            Instant endDate = punishment.getEndDate();
            return new MutePluginCompatibilityProvider.Mute(playerName, reason, moderator, endDate);
        });
    }

    private CompletableFuture<Optional<Punishment>> getPunishment(Player player) {
        return ((SelectionByApplicability)((SelectionByApplicabilityBuilder)this.lb.getSelector().selectionByApplicabilityBuilder(player.getUniqueId(), player.getRemoteAddress().getAddress()).type(PunishmentType.MUTE)).build()).getFirstSpecificPunishment().toCompletableFuture();
    }
}

