/*
 * Decompiled with CFR 0.152.
 */
package off.szymon.vMessage.compatibility.mute;

import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ServerConnection;
import java.time.Instant;
import java.util.concurrent.CompletableFuture;
import litebans.api.Database;
import litebans.api.Entry;
import off.szymon.vMessage.compatibility.mute.MutePluginCompatibilityProvider;

public class LiteBansCompatibilityProvider
implements MutePluginCompatibilityProvider {
    private final Database database = Database.get();

    @Override
    public CompletableFuture<Boolean> isMuted(Player player) {
        return CompletableFuture.supplyAsync(() -> this.database.isPlayerMuted(player.getUniqueId(), player.getRemoteAddress().getAddress().toString(), ((ServerConnection)player.getCurrentServer().get()).getServerInfo().getName()));
    }

    @Override
    public CompletableFuture<MutePluginCompatibilityProvider.Mute> getMute(Player player) {
        return CompletableFuture.supplyAsync(() -> {
            Entry entry = Database.get().getMute(player.getUniqueId(), player.getRemoteAddress().getAddress().toString(), ((ServerConnection)player.getCurrentServer().get()).getServerInfo().getName());
            String playerName = player.getUsername();
            String reason = entry.getReason() != null ? entry.getReason() : "No reason specified";
            String moderator = entry.getExecutorName() != null ? entry.getExecutorName() : "Unknown";
            Instant endDate = Instant.ofEpochSecond(entry.getDateEnd());
            return new MutePluginCompatibilityProvider.Mute(playerName, reason, moderator, endDate);
        });
    }
}

