/*
 * Decompiled with CFR 0.152.
 */
package off.szymon.vMessage.libs.configurate.objectmapping.meta;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import off.szymon.vMessage.libs.configurate.objectmapping.meta.Localization;
import off.szymon.vMessage.libs.configurate.objectmapping.meta.Matches;
import off.szymon.vMessage.libs.configurate.serialize.SerializationException;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface Constraint<V> {
    public void validate(@Nullable V var1) throws SerializationException;

    public static <T extends Annotation> Factory<T, Object> required() {
        return (data2, type2) -> value -> {
            if (value == null) {
                throw new SerializationException("A value is required for this field");
            }
        };
    }

    public static Factory<Matches, String> pattern() {
        return (data2, type2) -> {
            Pattern test = Pattern.compile(data2.value(), data2.flags());
            MessageFormat format = new MessageFormat(data2.failureMessage(), Locale.getDefault());
            return value -> {
                Matcher match;
                if (value != null && !(match = test.matcher((CharSequence)value)).matches()) {
                    throw new SerializationException(format.format(new Object[]{value, data2.value()}));
                }
            };
        };
    }

    public static Factory<Matches, String> localizedPattern(ResourceBundle bundle) {
        return (data2, type2) -> {
            Pattern test = Pattern.compile(data2.value(), data2.flags());
            MessageFormat format = new MessageFormat(Localization.key(bundle, data2.failureMessage()), bundle.getLocale());
            return value -> {
                Matcher match;
                if (value != null && !(match = test.matcher((CharSequence)value)).matches()) {
                    throw new SerializationException(format.format(new Object[]{value, data2.value()}));
                }
            };
        };
    }

    public static interface Factory<A extends Annotation, V> {
        public Constraint<V> make(A var1, Type var2);
    }
}

