/*
 * Decompiled with CFR 0.152.
 */
package off.szymon.vMessage.libs.configurate.objectmapping.meta;

import io.leangen.geantyref.GenericTypeReflector;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import off.szymon.vMessage.libs.configurate.objectmapping.meta.PostProcess;
import off.szymon.vMessage.libs.configurate.serialize.SerializationException;
import off.szymon.vMessage.libs.configurate.util.Types;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface PostProcessor {
    public void postProcess(Object var1) throws SerializationException;

    public static Factory methodsAnnotated(Class<? extends Annotation> annotation) {
        return type2 -> {
            ArrayList<Method> methods2 = null;
            for (Method method : Types.allDeclaredMethods(GenericTypeReflector.erase((Type)type2))) {
                int modifiers;
                if (!method.isAnnotationPresent(annotation) || Modifier.isAbstract(modifiers = method.getModifiers())) continue;
                if (Modifier.isStatic(modifiers)) {
                    throw new SerializationException(type2, "Post-processor method " + method.getName() + "() annotated @" + annotation.getSimpleName() + " must not be static.");
                }
                if (method.getParameterCount() != 0) {
                    throw new SerializationException(type2, "Post-processor method " + method.getName() + "() annotated @" + annotation.getSimpleName() + " must not take any parameters.");
                }
                for (Class<?> exception : method.getExceptionTypes()) {
                    if (SerializationException.class.isAssignableFrom(exception)) continue;
                    throw new SerializationException(type2, "Post-processor method " + method.getName() + "() annotated @" + annotation.getSimpleName() + " must only throw SerializationException or its subtypes, but is declared to throw " + exception.getSimpleName() + ".");
                }
                method.setAccessible(true);
                if (methods2 == null) {
                    methods2 = new ArrayList<Method>();
                }
                methods2.add(method);
            }
            if (methods2 != null) {
                ArrayList<Method> finalMethods = methods2;
                return instance -> {
                    SerializationException aggregateException = null;
                    for (Method postProcessorMethod : finalMethods) {
                        SerializationException exc = null;
                        try {
                            postProcessorMethod.invoke(instance, new Object[0]);
                        }
                        catch (InvocationTargetException ex) {
                            if (ex.getCause() instanceof SerializationException) {
                                exc = (SerializationException)ex.getCause();
                                exc.initType(type2);
                            } else {
                                exc = ex.getCause() != null ? new SerializationException(type2, "Failure occurred in post-processor method " + postProcessorMethod.getName() + "()", ex.getCause()) : new SerializationException(type2, "Unknown error occurred attempting to invoke post-processor method " + postProcessorMethod.getName() + "()", (Throwable)ex);
                            }
                        }
                        catch (IllegalAccessException | IllegalArgumentException ex) {
                            exc = new SerializationException(type2, "Failed to invoke post-processor method " + postProcessorMethod.getName() + "()", (Throwable)ex);
                        }
                        if (exc == null) continue;
                        if (aggregateException == null) {
                            aggregateException = exc;
                            continue;
                        }
                        aggregateException.addSuppressed(exc);
                    }
                    if (aggregateException != null) {
                        throw aggregateException;
                    }
                };
            }
            return null;
        };
    }

    public static Factory methodsAnnotatedPostProcess() {
        return PostProcessor.methodsAnnotated(PostProcess.class);
    }

    public static interface Factory {
        public @Nullable PostProcessor createProcessor(Type var1) throws SerializationException;
    }
}

