/*
 * Decompiled with CFR 0.152.
 */
package off.szymon.vMessage.libs.configurate.reactive;

import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import off.szymon.vMessage.libs.configurate.reactive.MappedProcessor;
import off.szymon.vMessage.libs.configurate.reactive.ProcessorImpl;
import off.szymon.vMessage.libs.configurate.reactive.Publisher;
import off.szymon.vMessage.libs.configurate.reactive.Subscriber;
import off.szymon.vMessage.libs.configurate.reactive.TransactionFailedException;
import off.szymon.vMessage.libs.configurate.reactive.TransactionalProcessorImpl;
import off.szymon.vMessage.libs.configurate.reactive.TransactionalSubscriber;
import off.szymon.vMessage.libs.configurate.util.CheckedFunction;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface Processor<I, O>
extends Publisher<O>,
Subscriber<I> {
    public static <V> Iso<V> create() {
        return Processor.create(ForkJoinPool.commonPool());
    }

    public static <V> Iso<V> create(Executor executor2) {
        return new ProcessorImpl(executor2);
    }

    public static <V> TransactionalIso<V> createTransactional() {
        return Processor.createTransactional(ForkJoinPool.commonPool());
    }

    public static <V> TransactionalIso<V> createTransactional(Executor exec) {
        return new TransactionalProcessorImpl(exec);
    }

    default public <R> Processor<O, R> map(CheckedFunction<? super O, ? extends R, TransactionFailedException> mapper) {
        return new MappedProcessor<O, R>(mapper, this);
    }

    public void inject(O var1);

    public void fallbackHandler(@Nullable Subscriber<O> var1);

    public boolean closeIfUnsubscribed();

    public static interface Iso<V>
    extends Processor<V, V> {
        @Override
        default public void inject(V element) {
            this.submit(element);
        }
    }

    public static interface TransactionalIso<V>
    extends Transactional<V, V>,
    Iso<V> {
    }

    public static interface Transactional<I, O>
    extends Processor<I, O>,
    Publisher<O>,
    TransactionalSubscriber<I> {
    }
}

