/*
 * Decompiled with CFR 0.152.
 */
package off.szymon.vMessage.libs.configurate.serialize;

import com.google.errorprone.annotations.ForOverride;
import io.leangen.geantyref.GenericTypeReflector;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import off.szymon.vMessage.libs.configurate.ConfigurationNode;
import off.szymon.vMessage.libs.configurate.ConfigurationOptions;
import off.szymon.vMessage.libs.configurate.serialize.SerializationException;
import off.szymon.vMessage.libs.configurate.serialize.TypeSerializer;
import off.szymon.vMessage.libs.configurate.util.CheckedConsumer;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractListChildSerializer<T>
implements TypeSerializer.Annotated<T> {
    protected AbstractListChildSerializer() {
    }

    @Override
    public final T deserialize(AnnotatedType type2, ConfigurationNode node) throws SerializationException {
        AnnotatedType entryType = this.elementType(type2);
        @Nullable TypeSerializer<?> entrySerial = node.options().serializers().get(entryType);
        if (entrySerial == null) {
            throw new SerializationException(node, entryType, "No applicable type serializer for type");
        }
        if (node.isList()) {
            List<? extends ConfigurationNode> values2 = node.childrenList();
            T ret2 = this.createNew(values2.size(), entryType);
            for (int i2 = 0; i2 < values2.size(); ++i2) {
                try {
                    this.deserializeSingle(i2, ret2, entrySerial.deserialize(entryType, values2.get(i2)));
                    continue;
                }
                catch (SerializationException ex) {
                    ex.initPath(values2.get(i2)::path);
                    throw ex;
                }
            }
            return ret2;
        }
        @Nullable Object unwrappedVal = node.raw();
        if (unwrappedVal != null) {
            T ret3 = this.createNew(1, entryType);
            this.deserializeSingle(0, ret3, entrySerial.deserialize(entryType, node));
            return ret3;
        }
        return this.createNew(0, entryType);
    }

    @Override
    public final void serialize(AnnotatedType type2, @Nullable T obj, ConfigurationNode node) throws SerializationException {
        AnnotatedType entryType = this.elementType(type2);
        @Nullable TypeSerializer<?> entrySerial = node.options().serializers().get(entryType);
        if (entrySerial == null) {
            throw new SerializationException(node, entryType, "No applicable type serializer for type");
        }
        node.raw(Collections.emptyList());
        if (obj != null) {
            this.forEachElement(obj, el -> {
                ConfigurationNode child = node.appendListNode();
                try {
                    entrySerial.serialize(entryType, el, child);
                }
                catch (SerializationException ex) {
                    ex.initPath(child::path);
                    throw ex;
                }
            });
        }
    }

    @Override
    public @Nullable T emptyValue(AnnotatedType specificType, ConfigurationOptions options) {
        try {
            return this.createNew(0, this.elementType(specificType));
        }
        catch (SerializationException ex) {
            return null;
        }
    }

    @ForOverride
    protected AnnotatedType elementType(AnnotatedType containerType) throws SerializationException {
        return GenericTypeReflector.annotate((Type)this.elementType(containerType.getType()));
    }

    @Deprecated
    protected Type elementType(Type containerType) throws SerializationException {
        throw new IllegalStateException("AbstractListChildSerializer implementations should override elementType(AnnotatedType)");
    }

    @ForOverride
    protected T createNew(int length, AnnotatedType elementType) throws SerializationException {
        return this.createNew(length, elementType.getType());
    }

    @Deprecated
    @ForOverride
    protected T createNew(int length, Type elementType) throws SerializationException {
        throw new IllegalStateException("AbstractListChildSerializer implementations should override createNew(int, AnnotatedType)");
    }

    @ForOverride
    protected abstract void forEachElement(T var1, CheckedConsumer<Object, SerializationException> var2) throws SerializationException;

    @ForOverride
    protected abstract void deserializeSingle(int var1, T var2, @Nullable Object var3) throws SerializationException;
}

