/*
 * Decompiled with CFR 0.152.
 */
package off.szymon.vMessage.libs.configurate.serialize;

import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.geantyref.TypeToken;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.function.Predicate;
import off.szymon.vMessage.libs.configurate.ConfigurationNode;
import off.szymon.vMessage.libs.configurate.serialize.SerializationException;
import off.szymon.vMessage.libs.configurate.serialize.TypeSerializer;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class ScalarSerializer<T>
implements TypeSerializer.Annotated<T> {
    private final TypeToken<T> type;

    protected ScalarSerializer(TypeToken<T> type2) {
        Type boxed = GenericTypeReflector.box((Type)type2.getType());
        this.type = boxed == type2.getType() ? type2 : TypeToken.get((Type)boxed);
    }

    protected ScalarSerializer(Class<T> type2) {
        if (type2.getTypeParameters().length > 0) {
            throw new IllegalArgumentException("Provided type " + type2 + " has type parameters but was not provided as a TypeToken!");
        }
        this.type = TypeToken.get(type2);
    }

    ScalarSerializer(Type type2) {
        this.type = TypeToken.get((Type)type2);
    }

    public final TypeToken<T> type() {
        return this.type;
    }

    @Override
    public final T deserialize(Type type2, ConfigurationNode node) throws SerializationException {
        return (T)TypeSerializer.Annotated.super.deserialize(type2, node);
    }

    @Override
    public final T deserialize(AnnotatedType type2, ConfigurationNode node) throws SerializationException {
        List<? extends ConfigurationNode> children2;
        ConfigurationNode deserializeFrom = node;
        if (node.isList() && (children2 = node.childrenList()).size() == 1) {
            deserializeFrom = children2.get(0);
        }
        if (deserializeFrom.isList() || deserializeFrom.isMap()) {
            throw new SerializationException(type2, "Value must be provided as a scalar!");
        }
        @Nullable Object value = deserializeFrom.rawScalar();
        if (value == null) {
            throw new SerializationException(type2, "No scalar value present");
        }
        type2 = GenericTypeReflector.toCanonicalBoxed((AnnotatedType)type2);
        @Nullable T possible = this.cast(value);
        if (possible != null) {
            return possible;
        }
        return this.deserialize(type2, value);
    }

    public final T deserialize(Object value) throws SerializationException {
        @Nullable T possible = this.cast(value);
        if (possible != null) {
            return possible;
        }
        return this.deserialize(this.type().getAnnotatedType(), value);
    }

    public T deserialize(AnnotatedType type2, Object obj) throws SerializationException {
        return this.deserialize(type2.getType(), obj);
    }

    public abstract T deserialize(Type var1, Object var2) throws SerializationException;

    @Override
    public final void serialize(AnnotatedType type2, @Nullable T obj, ConfigurationNode node) throws SerializationException {
        this.serialize(type2.getType(), obj, node);
    }

    @Override
    public final void serialize(Type type2, @Nullable T obj, ConfigurationNode node) {
        if (obj == null) {
            node.raw(null);
            return;
        }
        if (node.options().acceptsType(obj.getClass())) {
            node.raw(obj);
            return;
        }
        node.raw(this.serialize(obj, node.options()::acceptsType));
    }

    protected abstract Object serialize(T var1, Predicate<Class<?>> var2);

    private @Nullable T cast(Object value) {
        Class rawType = GenericTypeReflector.erase((Type)this.type().getType());
        if (rawType.isInstance(value)) {
            return (T)value;
        }
        return null;
    }

    public final @Nullable T tryDeserialize(@Nullable Object obj) {
        if (obj == null) {
            return null;
        }
        try {
            return this.deserialize(obj);
        }
        catch (SerializationException ex) {
            return null;
        }
    }

    public final String serializeToString(T item) {
        if (item instanceof CharSequence) {
            return item.toString();
        }
        return (String)this.serialize(item, clazz -> clazz.isAssignableFrom(String.class));
    }

    public static abstract class Annotated<V>
    extends ScalarSerializer<V> {
        protected Annotated(Class<V> type2) {
            super(type2);
        }

        protected Annotated(TypeToken<V> type2) {
            super(type2);
        }

        @Override
        public abstract V deserialize(AnnotatedType var1, Object var2) throws SerializationException;

        @Override
        public V deserialize(Type type2, Object obj) throws SerializationException {
            return this.deserialize(GenericTypeReflector.annotate((Type)type2), obj);
        }
    }
}

