/*
 * Decompiled with CFR 0.152.
 */
package off.szymon.vMessage.libs.configurate.serialize;

import io.leangen.geantyref.GenericTypeReflector;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import off.szymon.vMessage.libs.configurate.ConfigurationNode;
import off.szymon.vMessage.libs.configurate.ConfigurationOptions;
import off.szymon.vMessage.libs.configurate.serialize.FunctionScalarSerializer;
import off.szymon.vMessage.libs.configurate.serialize.ScalarSerializer;
import off.szymon.vMessage.libs.configurate.serialize.SerializationException;
import off.szymon.vMessage.libs.configurate.util.CheckedFunction;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface TypeSerializer<T> {
    public static <T> ScalarSerializer<T> of(Type type2, BiFunction<T, Predicate<Class<?>>, Object> serializer, CheckedFunction<Object, T, SerializationException> deserializer) {
        return new FunctionScalarSerializer<T>(type2, deserializer, serializer);
    }

    public static <T> ScalarSerializer<T> of(Class<T> type2, BiFunction<T, Predicate<Class<?>>, Object> serializer, CheckedFunction<Object, T, SerializationException> deserializer) {
        if (type2.getTypeParameters().length > 0) {
            throw new IllegalArgumentException("Parameterized types must be specified using TypeTokens, not raw classes");
        }
        return new FunctionScalarSerializer<T>(type2, deserializer, serializer);
    }

    default public T deserialize(AnnotatedType type2, ConfigurationNode node) throws SerializationException {
        return this.deserialize(type2.getType(), node);
    }

    public T deserialize(Type var1, ConfigurationNode var2) throws SerializationException;

    default public void serialize(AnnotatedType type2, @Nullable T obj, ConfigurationNode node) throws SerializationException {
        this.serialize(type2.getType(), obj, node);
    }

    public void serialize(Type var1, @Nullable T var2, ConfigurationNode var3) throws SerializationException;

    default public @Nullable T emptyValue(Type specificType, ConfigurationOptions options) {
        return null;
    }

    default public @Nullable T emptyValue(AnnotatedType specificType, ConfigurationOptions options) {
        return this.emptyValue(specificType.getType(), options);
    }

    public static interface Annotated<V>
    extends TypeSerializer<V> {
        @Override
        public V deserialize(AnnotatedType var1, ConfigurationNode var2) throws SerializationException;

        @Override
        default public V deserialize(Type type2, ConfigurationNode node) throws SerializationException {
            return this.deserialize(GenericTypeReflector.annotate((Type)type2), node);
        }

        @Override
        public void serialize(AnnotatedType var1, @Nullable V var2, ConfigurationNode var3) throws SerializationException;

        @Override
        default public void serialize(Type type2, @Nullable V obj, ConfigurationNode node) throws SerializationException {
            this.serialize(GenericTypeReflector.annotate((Type)type2), obj, node);
        }

        @Override
        default public @Nullable V emptyValue(AnnotatedType specificType, ConfigurationOptions options) {
            return null;
        }

        @Override
        default public @Nullable V emptyValue(Type specificType, ConfigurationOptions options) {
            return this.emptyValue(GenericTypeReflector.annotate((Type)specificType), options);
        }
    }
}

