/*
 * Decompiled with CFR 0.152.
 */
package off.szymon.vMessage.libs.configurate.yaml.internal.snakeyaml.introspector;

import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import off.szymon.vMessage.libs.configurate.yaml.internal.snakeyaml.error.YAMLException;
import off.szymon.vMessage.libs.configurate.yaml.internal.snakeyaml.introspector.BeanAccess;
import off.szymon.vMessage.libs.configurate.yaml.internal.snakeyaml.introspector.FieldProperty;
import off.szymon.vMessage.libs.configurate.yaml.internal.snakeyaml.introspector.MethodProperty;
import off.szymon.vMessage.libs.configurate.yaml.internal.snakeyaml.introspector.MissingProperty;
import off.szymon.vMessage.libs.configurate.yaml.internal.snakeyaml.introspector.Property;
import off.szymon.vMessage.libs.configurate.yaml.internal.snakeyaml.util.PlatformFeatureDetector;

public class PropertyUtils {
    private final Map<Class<?>, Map<String, Property>> propertiesCache = new HashMap();
    private final Map<Class<?>, Set<Property>> readableProperties = new HashMap();
    private BeanAccess beanAccess = BeanAccess.DEFAULT;
    private boolean allowReadOnlyProperties = false;
    private boolean skipMissingProperties = false;
    private final PlatformFeatureDetector platformFeatureDetector;
    private static final String TRANSIENT = "transient";

    public PropertyUtils() {
        this(new PlatformFeatureDetector());
    }

    PropertyUtils(PlatformFeatureDetector platformFeatureDetector) {
        this.platformFeatureDetector = platformFeatureDetector;
        if (platformFeatureDetector.isRunningOnAndroid()) {
            this.beanAccess = BeanAccess.FIELD;
        }
    }

    protected Map<String, Property> getPropertiesMap(Class<?> type2, BeanAccess bAccess) {
        if (this.propertiesCache.containsKey(type2)) {
            return this.propertiesCache.get(type2);
        }
        LinkedHashMap<String, Property> properties2 = new LinkedHashMap<String, Property>();
        boolean inaccessableFieldsExist = false;
        if (bAccess == BeanAccess.FIELD) {
            for (Class<?> c = type2; c != null; c = c.getSuperclass()) {
                for (Field field : c.getDeclaredFields()) {
                    int modifiers = field.getModifiers();
                    if (Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers) || properties2.containsKey(field.getName())) continue;
                    properties2.put(field.getName(), new FieldProperty(field));
                }
            }
        } else {
            Object c;
            try {
                c = Introspector.getBeanInfo(type2).getPropertyDescriptors();
                int n = ((PropertyDescriptor[])c).length;
                for (int j = 0; j < n; ++j) {
                    PropertyDescriptor property = c[j];
                    Method readMethod = property.getReadMethod();
                    if (readMethod != null && readMethod.getName().equals("getClass") || this.isTransient(property)) continue;
                    properties2.put(property.getName(), new MethodProperty(property));
                }
            }
            catch (IntrospectionException e) {
                throw new YAMLException(e);
            }
            for (c = type2; c != null; c = ((Class)c).getSuperclass()) {
                for (Field field : ((Class)c).getDeclaredFields()) {
                    int modifiers = field.getModifiers();
                    if (Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers)) continue;
                    if (Modifier.isPublic(modifiers)) {
                        properties2.put(field.getName(), new FieldProperty(field));
                        continue;
                    }
                    inaccessableFieldsExist = true;
                }
            }
        }
        if (properties2.isEmpty() && inaccessableFieldsExist) {
            throw new YAMLException("No JavaBean properties found in " + type2.getName());
        }
        this.propertiesCache.put(type2, properties2);
        return properties2;
    }

    private boolean isTransient(FeatureDescriptor fd) {
        return Boolean.TRUE.equals(fd.getValue(TRANSIENT));
    }

    public Set<Property> getProperties(Class<? extends Object> type2) {
        return this.getProperties(type2, this.beanAccess);
    }

    public Set<Property> getProperties(Class<? extends Object> type2, BeanAccess bAccess) {
        if (this.readableProperties.containsKey(type2)) {
            return this.readableProperties.get(type2);
        }
        Set<Property> properties2 = this.createPropertySet(type2, bAccess);
        this.readableProperties.put(type2, properties2);
        return properties2;
    }

    protected Set<Property> createPropertySet(Class<? extends Object> type2, BeanAccess bAccess) {
        TreeSet<Property> properties2 = new TreeSet<Property>();
        Collection<Property> props = this.getPropertiesMap(type2, bAccess).values();
        for (Property property : props) {
            if (!property.isReadable() || !this.allowReadOnlyProperties && !property.isWritable()) continue;
            properties2.add(property);
        }
        return properties2;
    }

    public Property getProperty(Class<? extends Object> type2, String name) {
        return this.getProperty(type2, name, this.beanAccess);
    }

    public Property getProperty(Class<? extends Object> type2, String name, BeanAccess bAccess) {
        Map<String, Property> properties2 = this.getPropertiesMap(type2, bAccess);
        Property property = properties2.get(name);
        if (property == null && this.skipMissingProperties) {
            property = new MissingProperty(name);
        }
        if (property == null) {
            throw new YAMLException("Unable to find property '" + name + "' on class: " + type2.getName());
        }
        return property;
    }

    public void setBeanAccess(BeanAccess beanAccess) {
        if (this.platformFeatureDetector.isRunningOnAndroid() && beanAccess != BeanAccess.FIELD) {
            throw new IllegalArgumentException("JVM is Android - only BeanAccess.FIELD is available");
        }
        if (this.beanAccess != beanAccess) {
            this.beanAccess = beanAccess;
            this.propertiesCache.clear();
            this.readableProperties.clear();
        }
    }

    public void setAllowReadOnlyProperties(boolean allowReadOnlyProperties) {
        if (this.allowReadOnlyProperties != allowReadOnlyProperties) {
            this.allowReadOnlyProperties = allowReadOnlyProperties;
            this.readableProperties.clear();
        }
    }

    public boolean isAllowReadOnlyProperties() {
        return this.allowReadOnlyProperties;
    }

    public void setSkipMissingProperties(boolean skipMissingProperties) {
        if (this.skipMissingProperties != skipMissingProperties) {
            this.skipMissingProperties = skipMissingProperties;
            this.readableProperties.clear();
        }
    }

    public boolean isSkipMissingProperties() {
        return this.skipMissingProperties;
    }
}

