/*
 * Decompiled with CFR 0.152.
 */
package org.simpleyaml.configuration.comments.format;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Objects;
import org.simpleyaml.configuration.comments.CommentType;
import org.simpleyaml.configuration.comments.KeyTree;
import org.simpleyaml.configuration.comments.format.CommentFormatter;
import org.simpleyaml.configuration.comments.format.YamlCommentFormatterConfiguration;
import org.simpleyaml.utils.StringUtils;
import org.simpleyaml.utils.Validate;

public class YamlHeaderFormatter
implements CommentFormatter {
    protected YamlCommentFormatterConfiguration configuration;

    protected YamlHeaderFormatter(YamlCommentFormatterConfiguration configuration) {
        Validate.notNull(configuration);
        this.configuration = configuration;
    }

    public YamlHeaderFormatter(String commentPrefix, boolean strip) {
        this(new YamlCommentFormatterConfiguration().prefix(commentPrefix).stripPrefix(strip).suffix("\n\n"));
    }

    public YamlHeaderFormatter() {
        this("# ", false);
    }

    @Override
    public String parse(String raw, CommentType type, KeyTree.Node node) throws IOException {
        if (raw == null) {
            return null;
        }
        return this.parse(new StringReader(raw), type, node);
    }

    @Override
    public String parse(Reader raw, CommentType type, KeyTree.Node node) throws IOException {
        if (raw == null) {
            return null;
        }
        try (BufferedReader reader = raw instanceof BufferedReader ? (BufferedReader)raw : new BufferedReader(raw);){
            String line;
            StringBuilder headerBuilder = new StringBuilder();
            boolean headerFound = false;
            while ((line = reader.readLine()) != null) {
                String trim = line.trim();
                if (trim.isEmpty()) {
                    if (headerFound) break;
                    headerBuilder.append('\n');
                    continue;
                }
                if (trim.startsWith("#")) {
                    if (this.stripPrefix()) {
                        line = StringUtils.stripPrefix(trim, this.commentPrefix(), "#");
                    }
                    if (headerFound) {
                        headerBuilder.append('\n');
                    } else {
                        headerFound = true;
                    }
                    headerBuilder.append(line);
                    continue;
                }
                headerFound = false;
                break;
            }
            if (headerFound) {
                String string = headerBuilder.toString();
                return string;
            }
        }
        return null;
    }

    @Override
    public String dump(String header, CommentType type, KeyTree.Node node) {
        String suffixLastPrefix;
        if (header == null) {
            return null;
        }
        String prefixFirst = null;
        String prefixMultiline = null;
        String suffixLast = null;
        String suffixMultiline = null;
        if (!StringUtils.allLinesArePrefixed(header, "#")) {
            String prefixFirstSuffix;
            prefixMultiline = this.commentPrefix();
            prefixFirst = this.configuration.prefixFirst(prefixMultiline);
            suffixMultiline = this.configuration.suffixMultiline();
            if (!prefixFirst.equals(prefixMultiline) && !prefixFirst.endsWith(prefixFirstSuffix = '\n' + prefixMultiline)) {
                prefixFirst = prefixFirst + prefixFirstSuffix;
            }
        }
        if (!header.endsWith(this.configuration.suffixLast())) {
            suffixLast = this.configuration.suffixLast();
        }
        if (suffixLast != null && suffixMultiline != null && !suffixMultiline.isEmpty() && !suffixLast.startsWith(suffixLastPrefix = suffixMultiline + '\n')) {
            suffixLast = suffixLastPrefix + suffixLast;
        }
        return CommentFormatter.format(prefixFirst, prefixMultiline, header, suffixMultiline, suffixLast);
    }

    public boolean stripPrefix() {
        return this.configuration.stripPrefix();
    }

    public YamlHeaderFormatter stripPrefix(boolean stripPrefix) {
        this.configuration.stripPrefix(stripPrefix);
        return this;
    }

    public String commentPrefix() {
        return this.configuration.prefixMultiline("# ");
    }

    public YamlHeaderFormatter commentPrefix(String commentPrefix) {
        String prefixFirst = this.configuration.prefixFirst("# ");
        if (prefixFirst.equals("# ")) {
            prefixFirst = commentPrefix;
        }
        this.configuration.prefix(prefixFirst, commentPrefix);
        return this;
    }

    public YamlHeaderFormatter prefixFirst(String commentPrefixFirst) {
        this.configuration.prefix(commentPrefixFirst, this.commentPrefix());
        return this;
    }

    public YamlHeaderFormatter commentSuffix(String suffixMultiline) {
        this.configuration.suffix(this.configuration.suffixLast("\n\n"), suffixMultiline);
        return this;
    }

    public YamlHeaderFormatter suffixLast(String suffixLast) {
        if (suffixLast == null) {
            suffixLast = "\n\n";
        } else if (!suffixLast.endsWith("\n\n")) {
            suffixLast = suffixLast + "\n\n";
        }
        this.configuration.suffix(suffixLast);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        YamlHeaderFormatter that = (YamlHeaderFormatter)o;
        return Objects.equals(this.configuration, that.configuration);
    }

    public int hashCode() {
        return Objects.hash(this.configuration);
    }
}

