/*
 * Decompiled with CFR 0.152.
 */
package lunar.tinkerer.enchantingTable;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import lunar.tinkerer.EnchantmentRecipe;
import lunar.tinkerer.MagicRevamped;
import lunar.tinkerer.ModBlockEntities;
import lunar.tinkerer.ModBlocks;
import lunar.tinkerer.ModItems;
import lunar.tinkerer.ModRecipeTypes;
import lunar.tinkerer.RuneItem;
import lunar.tinkerer.consequences.Consequence;
import lunar.tinkerer.consequences.ConsequenceManager;
import lunar.tinkerer.enchantingTable.EnchantingResultSlot;
import lunar.tinkerer.enchantingTable.EnchantingTableResultInventory;
import lunar.tinkerer.enchantingTable.ModEnchantingTableBlock;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1729;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2653;
import net.minecraft.class_2955;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3481;
import net.minecraft.class_3914;
import net.minecraft.class_3915;
import net.minecraft.class_5421;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7716;
import net.minecraft.class_8566;
import net.minecraft.class_8786;
import net.minecraft.class_9334;
import net.minecraft.class_9694;
import net.minecraft.class_9695;
import net.minecraft.class_9875;
import org.jetbrains.annotations.Nullable;

public class ModEnchantmentScreenHandler
extends class_1729 {
    public final class_3914 context;
    public final class_1657 player;
    private boolean filling;
    public static final int MAX_TIME_OUT = 20;
    public final class_3915 timeout = class_3915.method_17403();
    public final class_3915 seed = class_3915.method_17403();
    public final class_8566 craftingInventory;
    protected final EnchantingTableResultInventory craftingResultInventory = new EnchantingTableResultInventory();
    public EnchantingResultSlot resultSlot;

    public ModEnchantmentScreenHandler(int syncId, class_1661 playerInventory) {
        this(syncId, playerInventory, class_3914.field_17304);
    }

    public ModEnchantmentScreenHandler(int syncId, class_1661 playerInventory, class_3914 context) {
        super(ModBlockEntities.ENCHANTMENT_SCREEN_HANDLER, syncId);
        this.method_17362(this.seed).method_17404(playerInventory.field_7546.method_7278());
        this.method_17362(this.timeout).method_17404(0);
        this.context = context;
        this.player = playerInventory.field_7546;
        this.craftingInventory = new class_8566(){
            private final class_1703 handler;
            private final class_2371<class_1799> stacks;
            {
                this.handler = ModEnchantmentScreenHandler.this;
                this.stacks = class_2371.method_10213((int)9, (Object)class_1799.field_8037);
            }

            public void method_7683(class_9875 finder) {
                for (class_1799 itemStack : this.stacks) {
                    finder.method_61535(itemStack);
                }
            }

            public void method_5448() {
                this.stacks.clear();
            }

            public int method_5439() {
                return 9;
            }

            public boolean method_5442() {
                return this.stacks.stream().allMatch(class_1799::method_7960);
            }

            public class_1799 method_5438(int slot) {
                if (slot >= this.method_5439()) {
                    return class_1799.field_8037;
                }
                return (class_1799)this.stacks.get(slot);
            }

            public class_1799 method_5441(int slot) {
                return class_1262.method_5428(this.stacks, (int)slot);
            }

            public class_1799 method_5434(int slot, int amount) {
                class_1799 itemStack = class_1262.method_5430(this.stacks, (int)slot, (int)amount);
                if (!itemStack.method_7960()) {
                    this.handler.method_7609((class_1263)this);
                }
                return itemStack;
            }

            public void method_5447(int slot, class_1799 stack) {
                this.stacks.set(slot, (Object)stack);
                this.handler.method_7609((class_1263)this);
            }

            public void method_5431() {
                ModEnchantmentScreenHandler.this.method_7609((class_1263)this);
            }

            public boolean method_5443(class_1657 player) {
                return true;
            }

            public int method_17398() {
                return 3;
            }

            public int method_17397() {
                return 3;
            }

            public List<class_1799> method_51305() {
                return List.copyOf(this.stacks);
            }
        };
        this.resultSlot = new EnchantingResultSlot(this, this.player, this.craftingInventory, this.craftingResultInventory, 0, 127, 24);
        this.addResultSlot();
        this.addInputSlots(44, 24);
        this.method_61624((class_1263)playerInventory, 8, 91);
        context.method_17393((world, blockPos) -> Objects.requireNonNull(world.method_8503()).method_3742(this::tickTimeout));
    }

    protected void addResultSlot() {
        this.method_7621((class_1735)this.resultSlot);
    }

    protected void addInputSlots(int x, int y) {
        int offset = 30;
        int corner = 24;
        this.method_7621(new class_1735((class_1263)this.craftingInventory, 0, x, y));
        this.method_7621(new class_1735((class_1263)this.craftingInventory, 1, x, y - offset));
        this.method_7621(new class_1735((class_1263)this.craftingInventory, 2, x + corner, y - corner));
        this.method_7621(new class_1735((class_1263)this.craftingInventory, 3, x + offset, y));
        this.method_7621(new class_1735((class_1263)this.craftingInventory, 4, x + corner, y + corner));
        this.method_7621(new class_1735((class_1263)this.craftingInventory, 5, x, y + offset));
        this.method_7621(new class_1735((class_1263)this.craftingInventory, 6, x - corner, y + corner));
        this.method_7621(new class_1735((class_1263)this.craftingInventory, 7, x - offset, y));
        this.method_7621(new class_1735((class_1263)this.craftingInventory, 8, x - corner, y - corner));
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        this.context.method_17393((world, pos) -> this.method_7607(player, (class_1263)this.craftingInventory));
    }

    public boolean method_7597(class_1657 player) {
        return ModEnchantmentScreenHandler.method_17695((class_3914)this.context, (class_1657)player, (class_2248)ModBlocks.ENCHANTING_TABLE);
    }

    public class_1799 method_7601(class_1657 player, int slot) {
        class_1735 sourceSlot = (class_1735)this.field_7761.get(slot);
        class_1799 original = sourceSlot.method_7677().method_7972();
        class_1799 itemStack = switch (slot) {
            case 0 -> this.quickMoveFromResult(player, slot);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9 -> this.quickMoveFromTable(slot);
            default -> this.quickMoveFromPlayer(slot);
        };
        sourceSlot.method_7668();
        if (original.method_7947() == itemStack.method_7947()) {
            return class_1799.field_8037;
        }
        if (slot == 0) {
            player.method_7328(itemStack, false);
        } else {
            sourceSlot.method_7667(player, itemStack);
        }
        this.method_7623();
        return itemStack;
    }

    private class_1799 quickMoveFromResult(class_1657 player, int slot) {
        if (!this.resultSlot.method_7674(player)) {
            return class_1799.field_8037;
        }
        class_1799 items = this.resultSlot.method_7677();
        if (items.method_7960()) {
            return class_1799.field_8037;
        }
        this.resultSlot.method_7667(player, items);
        items.method_7909().method_54465(items, player);
        this.method_7616(items, 10, 46, true);
        this.method_7609((class_1263)this.craftingInventory);
        return items;
    }

    private class_1799 quickMoveFromTable(int slot) {
        class_1799 items = ((class_1735)this.field_7761.get(slot)).method_7677();
        this.method_7616(items, 10, 46, false);
        return items;
    }

    private class_1799 quickMoveFromPlayer(int slot) {
        class_1799 items = ((class_1735)this.field_7761.get(slot)).method_7677();
        if (this.method_7616(items, 1, 10, false)) {
            return items;
        }
        if (slot < 37) {
            this.method_7616(items, 37, 46, false);
        } else {
            this.method_7616(items, 10, 37, false);
        }
        return items;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public class_1729.class_9885 method_17697(boolean craftAll, boolean creative, class_8786<?> recipe, class_3218 world, class_1661 inventory) {
        class_8786<?> recipeEntry = recipe;
        this.onInputSlotFillStart();
        try {
            List<class_1735> list = this.getInputSlots();
            class_1729.class_9885 class_98852 = class_2955.method_61232((class_2955.class_9840)new class_2955.class_9840<EnchantmentRecipe>(){

                public void method_61237(class_9875 finder) {
                    ModEnchantmentScreenHandler.this.method_7654(finder);
                }

                public void method_61236() {
                    ModEnchantmentScreenHandler.this.craftingInventory.method_5448();
                }

                public boolean method_61238(class_8786<EnchantmentRecipe> entry) {
                    return ((EnchantmentRecipe)entry.comp_1933()).matches(ModEnchantmentScreenHandler.this.craftingInventory.method_59961(), ModEnchantmentScreenHandler.this.getPlayer().method_73183());
                }
            }, (int)3, (int)3, list, list, (class_1661)inventory, recipeEntry, (boolean)craftAll, (boolean)creative);
            return class_98852;
        }
        finally {
            this.onInputSlotFillFinish(world, recipeEntry);
        }
    }

    public void method_7654(class_9875 finder) {
        this.craftingInventory.method_7683(finder);
    }

    protected static void updateResult(ModEnchantmentScreenHandler handler, class_3218 world, class_1657 player, class_8566 craftingInventory, EnchantingTableResultInventory resultInventory, @Nullable class_8786<EnchantmentRecipe> recipe) {
        class_1799 conduit = craftingInventory.method_5438(0);
        class_3222 serverPlayerEntity = (class_3222)player;
        class_1799 itemStack = conduit.method_7960() ? class_1799.field_8037 : (conduit.method_31574(class_1802.field_8759) ? ModEnchantmentScreenHandler.carveRune(world, player, craftingInventory, resultInventory, recipe) : (conduit.method_31574(ModItems.RUNE) ? ModEnchantmentScreenHandler.stabilize(craftingInventory) : ModEnchantmentScreenHandler.enchant(craftingInventory)));
        resultInventory.method_5447(0, itemStack);
        handler.method_34245(0, itemStack);
        serverPlayerEntity.field_13987.method_14364((class_2596)new class_2653(handler.field_7763, handler.method_37422(), 0, itemStack));
    }

    private static class_1799 stabilize(class_8566 craftingInventory) {
        class_1799 conduit = craftingInventory.method_5438(0);
        if (!craftingInventory.method_51305().subList(1, 9).stream().allMatch(itemStack -> itemStack.method_7960() || itemStack.method_31574(class_1802.field_8477))) {
            return class_1799.field_8037;
        }
        int stabilization = craftingInventory.method_51305().subList(1, 9).stream().filter(itemStack -> !itemStack.method_7960()).filter(itemStack -> itemStack.method_31574(class_1802.field_8477)).toList().size();
        int currentFLux = Optional.ofNullable((Integer)conduit.method_58694(ModItems.FLUX)).orElse(8);
        int newFlux = Math.max(0, currentFLux - stabilization);
        if (newFlux == currentFLux) {
            return class_1799.field_8037;
        }
        class_1799 result = conduit.method_46651(1);
        result.method_57379(ModItems.FLUX, (Object)newFlux);
        return result;
    }

    private static class_1799 carveRune(class_3218 world, class_1657 player, class_8566 craftingInventory, EnchantingTableResultInventory resultInventory, @Nullable class_8786<EnchantmentRecipe> recipe) {
        class_9694 craftingRecipeInput = craftingInventory.method_59961();
        class_3222 serverPlayerEntity = (class_3222)player;
        class_1799 itemStack = class_1799.field_8037;
        if (recipe == null) {
            return itemStack;
        }
        Optional optional = world.method_8503().method_3772().method_42299(ModRecipeTypes.ENCHANTMENT_RECIPE_TYPE, (class_9695)craftingRecipeInput, (class_1937)world, recipe.comp_1932());
        if (optional.isPresent()) {
            class_1799 itemStack2;
            class_8786 recipeEntry = (class_8786)optional.get();
            EnchantmentRecipe craftingRecipe = (EnchantmentRecipe)recipeEntry.comp_1933();
            if (resultInventory.method_7665(serverPlayerEntity, recipeEntry) && (itemStack2 = craftingRecipe.craft(craftingRecipeInput, (class_7225.class_7874)world.method_30349())).method_45435(world.method_45162())) {
                itemStack = itemStack2;
            }
        }
        return itemStack;
    }

    public static class_1799 enchant(class_8566 craftingInventory) {
        class_1799 conduit = craftingInventory.method_5438(0);
        if (!class_1890.method_57529((class_1799)conduit) && !conduit.method_31574(class_1802.field_8529)) {
            return class_1799.field_8037;
        }
        if (!craftingInventory.method_51305().subList(1, 9).stream().allMatch(itemStack -> itemStack.method_7960() || ModEnchantmentScreenHandler.isValidRuneForItem(itemStack, conduit))) {
            return class_1799.field_8037;
        }
        List<class_1799> inputs = craftingInventory.method_51305().subList(1, 9).stream().filter(itemStack -> !itemStack.method_7960()).filter(itemStack -> itemStack.method_31574(ModItems.RUNE)).toList();
        if (inputs.isEmpty()) {
            return class_1799.field_8037;
        }
        class_1799 result = inputs.stream().filter(itemStack -> itemStack.method_58694(ModItems.ENCHANTMENT) != null).sorted((itemStack1, itemStack2) -> {
            int open1 = itemStack1.method_58694(ModItems.OPEN) != null ? 1 : 0;
            int open2 = itemStack2.method_58694(ModItems.OPEN) != null ? 1 : 0;
            int charged1 = itemStack1.method_58694(ModItems.CHARGED) != null ? 10 : 0;
            int charged2 = itemStack2.method_58694(ModItems.CHARGED) != null ? 10 : 0;
            return open1 + charged1 - open2 - charged2;
        }).reduce(conduit.method_31574(class_1802.field_8529) ? new class_1799((class_1935)class_1802.field_8598) : conduit.method_7972(), (subResult, rune) -> {
            class_1887 enchantment;
            class_6880 entry = (class_6880)rune.method_58694(ModItems.ENCHANTMENT);
            class_1887 class_18872 = enchantment = entry != null ? (class_1887)entry.comp_349() : null;
            if (!ModEnchantmentScreenHandler.isValidRuneForItem(rune, subResult)) {
                return subResult;
            }
            int nextLevel = ModEnchantmentScreenHandler.getResultEnchantmentLevel(subResult, (class_6880<class_1887>)entry, enchantment, rune);
            class_1890.method_57531((class_1799)subResult, builder -> builder.method_57550(entry, nextLevel));
            return subResult;
        });
        if (result.method_7963()) {
            result.method_57379(class_9334.field_50072, (Object)Math.max(result.method_7936() - 1, 1));
        }
        return result;
    }

    public static boolean isValidRuneForItem(class_1799 rune, class_1799 conduit) {
        if (!rune.method_31574(ModItems.RUNE)) {
            return false;
        }
        Optional<class_6880> runeEnchantmentRegistryEntryOptional = Optional.ofNullable((class_6880)rune.method_58694(ModItems.ENCHANTMENT));
        if (runeEnchantmentRegistryEntryOptional.isEmpty()) {
            return false;
        }
        boolean isAcceptable = runeEnchantmentRegistryEntryOptional.map(class_6880::comp_349).map(enchantment -> enchantment.method_8192(conduit) || conduit.method_31574(class_1802.field_8598) || conduit.method_31574(class_1802.field_8529)).orElse(false);
        if (!isAcceptable) {
            return false;
        }
        class_6880 runeEnchantmentRegistryEntry = runeEnchantmentRegistryEntryOptional.get();
        return conduit.method_58657().method_57534().stream().allMatch(conduitEnchantment -> conduitEnchantment.equals((Object)runeEnchantmentRegistryEntry) || class_1887.method_60033((class_6880)conduitEnchantment, (class_6880)runeEnchantmentRegistryEntry));
    }

    public static int getResultEnchantmentLevel(class_1799 itemStack, class_6880<class_1887> entry, class_1887 enchantment, class_1799 rune) {
        if (rune.method_58694(ModItems.OPEN) == null) {
            return 1;
        }
        int currentLevel = class_1890.method_57532((class_1799)itemStack).method_57536(entry);
        int maxLevel = rune.method_58694(ModItems.CHARGED) == null ? enchantment.method_8183() : enchantment.method_8183() + 1;
        return Math.min(currentLevel + 1, maxLevel);
    }

    public void method_7609(class_1263 inventory) {
        if (this.filling) {
            return;
        }
        this.context.method_17393((world, pos) -> {
            if (world instanceof class_3218) {
                class_3218 serverWorld = (class_3218)world;
                class_9694 input = this.craftingInventory.method_59961();
                class_8786 recipe = serverWorld.method_64577().method_8132(ModRecipeTypes.ENCHANTMENT_RECIPE_TYPE, (class_9695)input, (class_1937)serverWorld).orElse(null);
                ModEnchantmentScreenHandler.updateResult(this, serverWorld, this.player, this.craftingInventory, this.craftingResultInventory, (class_8786<EnchantmentRecipe>)recipe);
            }
        });
    }

    public void onInputSlotFillStart() {
        this.filling = true;
    }

    public void onInputSlotFillFinish(class_3218 world, class_8786<EnchantmentRecipe> recipe) {
        this.filling = false;
        ModEnchantmentScreenHandler.updateResult(this, world, this.player, this.craftingInventory, this.craftingResultInventory, recipe);
    }

    public List<class_1735> getInputSlots() {
        return this.field_7761.subList(1, 10);
    }

    public class_1735 getOutputSlot() {
        return (class_1735)this.field_7761.getFirst();
    }

    protected class_1657 getPlayer() {
        return this.player;
    }

    public class_5421 method_30264() {
        return class_5421.field_25763;
    }

    public int getSeed() {
        return this.seed.method_17407();
    }

    public static int getFlux(class_8566 input, class_1937 world) {
        int flux = input.method_51305().subList(1, 9).stream().map(itemStack -> Optional.ofNullable((Integer)itemStack.method_58694(ModItems.FLUX)).orElse(0)).reduce(0, Integer::sum);
        return flux * ModEnchantmentScreenHandler.getLevelRequirement(input, world);
    }

    public static double getMoonBonus(int moonPhase, boolean isNight) {
        if (!isNight) {
            return 1.0;
        }
        return switch (moonPhase) {
            case 0 -> 0.51;
            case 1, 7 -> 0.91;
            case 2, 6 -> 0.96;
            case 3, 5 -> 0.99;
            default -> 1.0;
        };
    }

    public static int getRuneCost(class_8566 input) {
        return input.method_51305().stream().filter(itemStack -> itemStack.method_31574(ModItems.RUNE)).map(itemStack -> (class_6880)itemStack.method_58694(ModItems.ENCHANTMENT)).filter(Objects::nonNull).map(class_6880::comp_349).filter(Objects::nonNull).map(class_1887::method_58446).reduce(0, (integer, integer2) -> 2 * integer + integer2);
    }

    public static int getInputCost(class_8566 input) {
        return RuneItem.getEnchantments(input.method_5438(0)).map(leveledEnchantment -> {
            int level = leveledEnchantment.level();
            int enchantmentCost = Optional.of(leveledEnchantment).map(RuneItem.LeveledEnchantment::enchantment).map(class_6880::comp_349).map(class_1887::method_58446).orElse(8);
            return level * enchantmentCost;
        }).reduce(0, Integer::sum);
    }

    public static int getLevelRequirement(class_8566 input, class_1937 world) {
        return Math.clamp((long)((int)Math.ceil(ModEnchantmentScreenHandler.getMoonBonus(world.method_30273(), world.method_23886()) * (double)(ModEnchantmentScreenHandler.getRuneCost(input) + ModEnchantmentScreenHandler.getInputCost(input)))), 0, 99);
    }

    public boolean doFluxCheck(class_1657 player, class_8566 input, class_1937 world, class_2338 blockPos) {
        int flux = ModEnchantmentScreenHandler.getFlux(input, world);
        int playerCheck = player.method_59922().method_39332(0, 1000);
        int bookshelfBonus = this.getBookshelfBonus(world, blockPos);
        int bookshelfCheck = player.method_59922().method_39332(Math.floorDiv(bookshelfBonus, 10), bookshelfBonus);
        boolean success = playerCheck + bookshelfCheck > flux;
        MagicRevamped.LOGGER.info("{} : [{}:1000 + {}:{}] {} {}", new Object[]{success ? "Success!" : "Failure :(", playerCheck, bookshelfCheck, bookshelfBonus, success ? ">" : "<", flux});
        return success;
    }

    public void tickTimeout() {
        int timeout = this.timeout.method_17407() - 1;
        this.timeout.method_17404(Math.max(0, timeout));
    }

    public void onTakeResult(class_1657 player, class_1799 stack) {
        this.context.method_17393((world, blockPos) -> {
            this.timeout.method_17404(20);
            boolean success = this.doFluxCheck(player, this.craftingInventory, (class_1937)world, (class_2338)blockPos);
            if (!success) {
                world.method_8396(null, blockPos, class_3417.field_15203, class_3419.field_15245, 1.0f, world.field_9229.method_43057() * 0.1f + 0.9f);
                Consequence.Result<class_1799> result = this.doConsequence((class_1937)world, (class_2338)blockPos, player, stack);
                stack.method_7939(result.entry().method_7947());
                stack.method_57365(result.entry().method_57353());
                player.method_7316(-ModEnchantmentScreenHandler.getLevelRequirement(this.craftingInventory, world));
                if (!result.success()) {
                    return;
                }
            }
            player.method_7281(class_3468.field_15420);
            world.method_8396(null, blockPos, class_3417.field_15119, class_3419.field_15245, 1.0f, world.field_9229.method_43057() * 0.1f + 0.9f);
            this.resultSlot.method_7669(stack);
            IntStream.range(0, this.craftingInventory.method_5439()).forEach(i -> this.craftingInventory.method_5434(i, 1));
        });
        this.craftingInventory.method_5431();
    }

    public Consequence.Result<class_1799> doConsequence(class_1937 world, class_2338 blockPos, class_1657 player, class_1799 stack) {
        if (!(world instanceof class_3218)) {
            return new Consequence.Result<class_1799>(class_1799.field_8037, false);
        }
        class_3218 serverWorld = (class_3218)world;
        if (!(player instanceof class_3222)) {
            return new Consequence.Result<class_1799>(class_1799.field_8037, false);
        }
        class_3222 serverPlayer = (class_3222)player;
        Consequence consequence = ConsequenceManager.pick(world, ModEnchantingTableBlock.DECORATION_OFFSETS.stream().map(blockPos1 -> blockPos1.method_10081((class_2382)blockPos)).toList());
        return consequence.run(serverWorld, blockPos, serverPlayer, this.craftingInventory, stack);
    }

    public int getBookBonus(class_1799 itemStack) {
        List<RuneItem.LeveledEnchantment> enchantments = RuneItem.getEnchantments(itemStack).toList();
        int specialtyBonus = this.craftingInventory.method_51305().subList(1, 9).stream().map(itemStack1 -> Optional.ofNullable((class_6880)itemStack1.method_58694(ModItems.ENCHANTMENT)).map(class_6880::comp_349)).anyMatch(enchantment -> enchantments.stream().map(RuneItem.LeveledEnchantment::enchantment).map(class_6880::comp_349).anyMatch(enchantment1 -> enchantment.filter(value -> value == enchantment1).isPresent())) ? 10 : 0;
        return specialtyBonus + enchantments.stream().map(RuneItem.LeveledEnchantment::level).map(i -> switch (i) {
            case 1 -> 3;
            case 2 -> 5;
            case 3 -> 8;
            case 4 -> 13;
            case 5 -> 21;
            case 6 -> 34;
            default -> 1;
        }).reduce(1, Integer::max);
    }

    public int getSingleBookshelfBonus(class_1937 world, class_2338 blockPos) {
        class_2586 blockEntity = world.method_8321(blockPos);
        if (!(blockEntity instanceof class_7716)) {
            return 3;
        }
        class_7716 chiseledBookshelfBlockEntity = (class_7716)blockEntity;
        AtomicInteger levelSum = new AtomicInteger();
        chiseledBookshelfBlockEntity.forEach(itemStack -> {
            if (itemStack.method_7960()) {
                return;
            }
            int maxEnchantLevel = this.getBookBonus((class_1799)itemStack);
            levelSum.addAndGet(maxEnchantLevel);
        });
        return levelSum.get();
    }

    public int getBookshelfBonus(class_1937 world, class_2338 blockPos) {
        return ModEnchantingTableBlock.POWER_PROVIDER_OFFSETS.stream().map(blockPos1 -> blockPos1.method_10081((class_2382)blockPos)).filter(blockPos1 -> world.method_8320(blockPos1).method_26164(class_3481.field_44472)).map(blockPos1 -> this.getSingleBookshelfBonus(world, (class_2338)blockPos1)).reduce(0, Integer::sum);
    }
}

