/*
 * Decompiled with CFR 0.152.
 */
package aboe.enchantlib.mixin;

import aboe.enchantlib.EnchantLib;
import aboe.enchantlib.config.ConfigGetter;
import aboe.enchantlib.config.Configs;
import aboe.enchantlib.util.EnchantmentPowerUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2331;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_2331.class})
public abstract class EnchantmentTableMixin
extends class_2237 {
    @Unique
    private static short tickUntilPerformanceUpdate = 0;
    private int tickUntilRenderUpdate = 0;
    public List<class_2338> validProvidersInArea = new ArrayList<class_2338>();

    protected EnchantmentTableMixin(class_4970.class_2251 arg) {
        super(arg);
    }

    @Inject(method={"randomDisplayTick"}, at={@At(value="HEAD")})
    public void randomDisplayTick(class_2680 state, class_1937 world, class_2338 pos, class_5819 random, CallbackInfo ci) {
        super.method_9496(state, world, pos, random);
        if (this.tickUntilRenderUpdate <= 0) {
            this.validProvidersInArea = EnchantmentPowerUtil.getPowerProvidersInArea(world, pos, ConfigGetter.getTableSize(), Configs.obType, Configs.getMoreShelves);
            this.tickUntilRenderUpdate = 10;
        } else {
            --this.tickUntilRenderUpdate;
        }
        if (!Configs.disableLogging) {
            EnchantmentTableMixin.echantlib$performanceWarning();
        }
        for (class_2338 providerOffset : this.validProvidersInArea) {
            if (random.method_43048(Configs.particleChance) != 0 || !(EnchantmentPowerUtil.getPowerFromBlock(world, pos.method_10081((class_2382)providerOffset), world.method_8320(pos.method_10081((class_2382)providerOffset))) > 0.0f)) continue;
            world.method_8406((class_2394)class_2398.field_11215, (double)((float)pos.method_10263() + 0.5f), (double)((float)pos.method_10264() + 2.0f), (double)pos.method_10260() + 0.5, (double)((float)providerOffset.method_10263() + random.method_43057() - 0.5f), (double)((float)providerOffset.method_10264() - random.method_43057() - 1.0f), (double)((float)providerOffset.method_10260() + random.method_43057() - 0.5f));
        }
    }

    @Unique
    private static void echantlib$performanceWarning() {
        if (Configs.XZSize > 15 && tickUntilPerformanceUpdate <= 0) {
            EnchantLib.logger.warn("Enchantment Table is set to a size of: {}. Performance might be hurt!", (Object)Configs.XZSize);
            tickUntilPerformanceUpdate = (short)560;
        } else {
            tickUntilPerformanceUpdate = (short)(tickUntilPerformanceUpdate - 1);
        }
    }

    @Inject(method={"canAccessPowerProvider"}, at={@At(value="HEAD")}, cancellable=true)
    private static void canAccessPowerProvider(class_1937 world, class_2338 tablePos, class_2338 providerOffset, CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)EnchantmentPowerUtil.isPathObstructed(world, tablePos, providerOffset.method_25503(), Configs.obType));
    }
}

