/*
 * Decompiled with CFR 0.152.
 */
package aboe.enchantlib.util;

import aboe.enchantlib.config.Configs;
import aboe.enchantlib.util.IEnchantmentPowerProvider;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3481;

public class EnchantmentPowerUtil {
    private static final List<class_2338> originArea = class_2338.method_17962((int)-1, (int)-1, (int)-1, (int)1, (int)1, (int)1).map(class_2338::method_10062).toList();
    public static Predicate<class_2680> isPowerProvider = state -> state.method_26204() instanceof IEnchantmentPowerProvider || state.method_26164(class_3481.field_44472);

    public static float getPowerFromBlock(class_1937 world, class_2338 pos, class_2680 state) {
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof IEnchantmentPowerProvider) {
            IEnchantmentPowerProvider provider = (IEnchantmentPowerProvider)class_22482;
            return provider.getEnchantmentPower(world, pos, state);
        }
        if (state.method_26164(class_3481.field_44472)) {
            return 1.0f;
        }
        return 0.0f;
    }

    public static boolean canBlockPath(class_1937 world, class_2338 pos, Configs.obstructionType obType) {
        if (Configs.enableAllowList && Configs.allowList.contains(Objects.requireNonNull(world.method_8320(pos).method_26204().arch$registryName()).toString())) {
            return false;
        }
        if (Configs.enableDenyList && Configs.denyList.contains(Objects.requireNonNull(world.method_8320(pos).method_26204().arch$registryName()).toString())) {
            return true;
        }
        if (obType == Configs.obstructionType.SOLID) {
            return world.method_8320(pos).method_26234((class_1922)world, pos);
        }
        if (obType == Configs.obstructionType.DEFAULT) {
            return !world.method_8320(pos).method_26164(class_3481.field_44473);
        }
        return false;
    }

    public static float getPowerFromArea(class_1937 world, class_2338 origin, List<class_2338> providers, Configs.obstructionType obstructionType2, Boolean getMoreShelves) {
        float power = 0.0f;
        class_2338.class_2339 shelfPos = new class_2338.class_2339();
        for (class_2338 shelfOffset : EnchantmentPowerUtil.getPowerProvidersInArea(world, origin, providers, obstructionType2, getMoreShelves)) {
            shelfPos.method_35831((class_2382)origin, (class_2382)shelfOffset);
            power += EnchantmentPowerUtil.getPowerFromBlock(world, (class_2338)shelfPos, world.method_8320((class_2338)shelfPos));
        }
        return power;
    }

    public static float getPowerFromProviders(class_1937 world, class_2338 origin, List<class_2338> providers) {
        float power = 0.0f;
        class_2338.class_2339 shelfPos = new class_2338.class_2339();
        for (class_2338 shelfOffset : providers) {
            shelfPos.method_35831((class_2382)origin, (class_2382)shelfOffset);
            power += EnchantmentPowerUtil.getPowerFromBlock(world, (class_2338)shelfPos, world.method_8320((class_2338)shelfPos));
        }
        return power;
    }

    public static List<class_2338> getPowerProvidersInArea(class_1937 world, class_2338 origin, List<class_2338> areaToSearch, Configs.obstructionType obType, boolean getMoreShelves) {
        ArrayList<class_2338> knownShelves = new ArrayList<class_2338>();
        for (class_2338 maxSearchPos : areaToSearch) {
            class_2338.class_2339 searchOffset = originArea.stream().sorted(Comparator.comparing(arg_0 -> ((class_2338)maxSearchPos).method_19455(arg_0))).toList().get(0).method_25503();
            EnchantmentPowerUtil.searchForShelf(world, origin, maxSearchPos, searchOffset, knownShelves, getMoreShelves, obType);
        }
        return knownShelves;
    }

    private static void searchForShelf(class_1937 world, class_2338 origin, class_2338 maxSearchPos, class_2338.class_2339 searchOffset, List<class_2338> knownShelves, Boolean getMoreShelves, Configs.obstructionType obType) {
        class_2338.class_2339 searchPos = new class_2338.class_2339();
        searchPos.method_35831((class_2382)origin, (class_2382)searchOffset);
        searchOffset.method_33098(maxSearchPos.method_10264());
        if (EnchantmentPowerUtil.canBlockPath(world, (class_2338)searchPos, obType)) {
            return;
        }
        while (searchOffset.method_10263() != maxSearchPos.method_10263() || searchOffset.method_10260() != maxSearchPos.method_10260()) {
            if (searchOffset.method_10263() != maxSearchPos.method_10263()) {
                searchOffset.method_33097(EnchantmentPowerUtil.moveByOneAdd(searchOffset.method_10263()));
            }
            if (searchOffset.method_10260() != maxSearchPos.method_10260()) {
                searchOffset.method_33099(EnchantmentPowerUtil.moveByOneAdd(searchOffset.method_10260()));
            }
            if (knownShelves.contains(searchOffset)) {
                if (!getMoreShelves.booleanValue()) break;
                continue;
            }
            searchPos.method_35831((class_2382)origin, (class_2382)searchOffset);
            if (isPowerProvider.test(world.method_8320((class_2338)searchPos))) {
                knownShelves.add(searchOffset.method_10062());
                if (!getMoreShelves.booleanValue()) break;
                continue;
            }
            if (!EnchantmentPowerUtil.canBlockPath(world, (class_2338)searchPos, obType)) continue;
            break;
        }
    }

    public static boolean isPathObstructed(class_1937 world, class_2338 origin, class_2338.class_2339 providerOffset, Configs.obstructionType type) {
        if (type == Configs.obstructionType.NONE) {
            return false;
        }
        class_2338.class_2339 searchPos = new class_2338.class_2339();
        class_2338 closestBlockToOrigin = originArea.stream().sorted(Comparator.comparing(arg_0 -> ((class_2338.class_2339)providerOffset).method_19455(arg_0))).toList().get(0);
        while (providerOffset.method_10260() != closestBlockToOrigin.method_10260() || providerOffset.method_10263() != closestBlockToOrigin.method_10263()) {
            if (providerOffset.method_10263() != closestBlockToOrigin.method_10263()) {
                providerOffset.method_33097(EnchantmentPowerUtil.moveByOneSub(providerOffset.method_10263()));
            }
            if (providerOffset.method_10260() != closestBlockToOrigin.method_10260()) {
                providerOffset.method_33099(EnchantmentPowerUtil.moveByOneSub(providerOffset.method_10260()));
            }
            if (Math.abs(providerOffset.method_10264()) > 2) {
                providerOffset.method_33098(EnchantmentPowerUtil.moveByOneSub(providerOffset.method_10264()));
            }
            searchPos.method_35831((class_2382)origin, (class_2382)providerOffset);
            if (type == Configs.obstructionType.SOLID && world.method_8320((class_2338)searchPos).method_26234((class_1922)world, (class_2338)searchPos)) {
                return true;
            }
            if (type != Configs.obstructionType.DEFAULT || world.method_8320((class_2338)searchPos).method_26164(class_3481.field_44473)) continue;
            return true;
        }
        return false;
    }

    private static int moveByOneSub(int pos) {
        return pos - pos / Math.abs(pos);
    }

    private static int moveByOneAdd(int pos) {
        return pos + pos / Math.abs(pos);
    }
}

