/*
 * Decompiled with CFR 0.152.
 */
package aboe.enchantlib.mixin;

import aboe.enchantlib.config.ConfigGetter;
import aboe.enchantlib.config.Configs;
import aboe.enchantlib.util.IEnchantmentPowerProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.ChiseledBookShelfBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChiseledBookShelfBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={ChiseledBookShelfBlock.class})
public abstract class ChiseledBookShelfMixin
extends BaseEntityBlock
implements IEnchantmentPowerProvider {
    protected ChiseledBookShelfMixin(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public int m_6782_(BlockState blockState, Level world, BlockPos blockPos) {
        if (world.f_46443_) {
            return 0;
        }
        BlockEntity blockEntity = world.m_7702_(blockPos);
        if (blockEntity instanceof ChiseledBookShelfBlockEntity) {
            ChiseledBookShelfBlockEntity shelfEntity = (ChiseledBookShelfBlockEntity)blockEntity;
            return Configs.modifyRedstoneOutput ? this.getRedstonePower(shelfEntity) : shelfEntity.m_262444_() + 1;
        }
        return 0;
    }

    private int getRedstonePower(ChiseledBookShelfBlockEntity shelfEntity) {
        int power = 0;
        for (int slot = 0; slot < 6; ++slot) {
            if (shelfEntity.m_8020_(slot).m_41619_()) continue;
            power += ConfigGetter.getBookRedstonePower(shelfEntity.m_8020_(slot));
        }
        return power;
    }

    @Override
    public float getEnchantmentPower(Level world, BlockPos pos, BlockState state) {
        float enchantedPower = 0.0f;
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof ChiseledBookShelfBlockEntity) {
            ChiseledBookShelfBlockEntity shelfBlock = (ChiseledBookShelfBlockEntity)blockEntity;
            for (int slot = 0; slot < 6; slot = (int)((byte)(slot + 1))) {
                if (shelfBlock.m_8020_(slot).m_41619_()) continue;
                enchantedPower += ConfigGetter.getBookEnchantmentPower(shelfBlock.m_8020_(slot));
            }
        }
        return enchantedPower;
    }
}

