/*
 * Decompiled with CFR 0.152.
 */
package aboe.enchantlib.mixin;

import aboe.enchantlib.EnchantLib;
import aboe.enchantlib.config.ConfigGetter;
import aboe.enchantlib.config.Configs;
import aboe.enchantlib.util.EnchantmentPowerUtil;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.EnchantmentMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={EnchantmentMenu.class}, priority=100)
public abstract class EnchantmentScreenHandlerMixin
extends AbstractContainerMenu {
    @Shadow
    @Final
    private Container f_39449_;
    @Shadow
    @Final
    private ContainerLevelAccess f_39450_;
    @Shadow
    @Final
    private RandomSource f_39451_;
    @Shadow
    @Final
    private DataSlot f_39452_;
    @Shadow
    @Final
    public int[] f_39446_;
    @Shadow
    @Final
    public int[] f_39447_;
    @Shadow
    @Final
    public int[] f_39448_;

    @Shadow
    protected abstract List<EnchantmentInstance> m_39471_(ItemStack var1, int var2, int var3);

    protected EnchantmentScreenHandlerMixin(@Nullable MenuType<?> type, int syncId) {
        super(type, syncId);
    }

    public void m_6199_(Container inventory) {
        if (inventory == this.f_39449_) {
            ItemStack itemStack = inventory.m_8020_(0);
            if (!itemStack.m_41619_() && itemStack.m_41792_()) {
                this.f_39450_.m_39292_((world, pos) -> {
                    int j;
                    if (Configs.XZSize > 15) {
                        EnchantLib.logger.warn("Enchantment Table is set to a size of: " + Configs.XZSize + ". Performance might be hurt!");
                    }
                    int powerLevel = (int)EnchantmentPowerUtil.getPowerFromArea(world, pos, ConfigGetter.getTableSize(), Configs.obType, Configs.getMoreShelves);
                    this.f_39451_.m_188584_((long)this.f_39452_.m_6501_());
                    for (j = 0; j < 3; ++j) {
                        this.f_39446_[j] = EnchantmentHelper.m_220287_((RandomSource)this.f_39451_, (int)j, (int)powerLevel, (ItemStack)itemStack);
                        this.f_39447_[j] = -1;
                        this.f_39448_[j] = -1;
                        if (this.f_39446_[j] >= j + 1) continue;
                        this.f_39446_[j] = 0;
                    }
                    for (j = 0; j < 3; ++j) {
                        List<EnchantmentInstance> list;
                        if (this.f_39446_[j] <= 0 || (list = this.m_39471_(itemStack, j, this.f_39446_[j])) == null || list.isEmpty()) continue;
                        EnchantmentInstance enchantmentLevelEntry = list.get(this.f_39451_.m_188503_(list.size()));
                        this.f_39447_[j] = BuiltInRegistries.f_256876_.m_7447_((Object)enchantmentLevelEntry.f_44947_);
                        this.f_39448_[j] = enchantmentLevelEntry.f_44948_;
                    }
                    this.m_38946_();
                });
            } else {
                for (int i = 0; i < 3; ++i) {
                    this.f_39446_[i] = 0;
                    this.f_39447_[i] = -1;
                    this.f_39448_[i] = -1;
                }
            }
        }
    }
}

