/*
 * Decompiled with CFR 0.152.
 */
package aboe.enchantlib.mixin;

import aboe.enchantlib.EnchantLib;
import aboe.enchantlib.config.ConfigGetter;
import aboe.enchantlib.config.Configs;
import aboe.enchantlib.util.EnchantmentPowerUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.EnchantmentTableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EnchantmentTableBlock.class})
public abstract class EnchantmentTableMixin
extends BaseEntityBlock {
    @Unique
    private static short tickUntilPerformanceUpdate = 0;
    private int tickUntilRenderUpdate = 0;
    public List<BlockPos> validProvidersInArea = new ArrayList<BlockPos>();

    protected EnchantmentTableMixin(BlockBehaviour.Properties arg) {
        super(arg);
    }

    @Inject(method={"randomDisplayTick"}, at={@At(value="HEAD")})
    public void randomDisplayTick(BlockState state, Level world, BlockPos pos, RandomSource random, CallbackInfo ci) {
        super.m_214162_(state, world, pos, random);
        if (this.tickUntilRenderUpdate <= 0) {
            this.validProvidersInArea = EnchantmentPowerUtil.getPowerProvidersInArea(world, pos, ConfigGetter.getTableSize(), Configs.obType, Configs.getMoreShelves);
            this.tickUntilRenderUpdate = 10;
        } else {
            --this.tickUntilRenderUpdate;
        }
        if (!Configs.disableLogging) {
            EnchantmentTableMixin.echantlib$performanceWarning();
        }
        for (BlockPos providerOffset : this.validProvidersInArea) {
            if (random.m_188503_(Configs.particleChance) != 0 || !(EnchantmentPowerUtil.getPowerFromBlock(world, pos.m_121955_((Vec3i)providerOffset), world.m_8055_(pos.m_121955_((Vec3i)providerOffset))) > 0.0f)) continue;
            world.m_7106_((ParticleOptions)ParticleTypes.f_123809_, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 2.0f), (double)pos.m_123343_() + 0.5, (double)((float)providerOffset.m_123341_() + random.m_188501_() - 0.5f), (double)((float)providerOffset.m_123342_() - random.m_188501_() - 1.0f), (double)((float)providerOffset.m_123343_() + random.m_188501_() - 0.5f));
        }
    }

    @Unique
    private static void echantlib$performanceWarning() {
        if (Configs.XZSize > 15 && tickUntilPerformanceUpdate <= 0) {
            EnchantLib.logger.warn("Enchantment Table is set to a size of: {}. Performance might be hurt!", (Object)Configs.XZSize);
            tickUntilPerformanceUpdate = (short)560;
        } else {
            tickUntilPerformanceUpdate = (short)(tickUntilPerformanceUpdate - 1);
        }
    }

    @Inject(method={"canAccessPowerProvider"}, at={@At(value="HEAD")}, cancellable=true)
    private static void canAccessPowerProvider(Level world, BlockPos tablePos, BlockPos providerOffset, CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)EnchantmentPowerUtil.isPathObstructed(world, tablePos, providerOffset.m_122032_(), Configs.obType));
    }
}

