/*
 * Decompiled with CFR 0.152.
 */
package aboe.enchantlib.util;

import aboe.enchantlib.config.Configs;
import aboe.enchantlib.util.IEnchantmentPowerProvider;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class EnchantmentPowerUtil {
    private static final List<BlockPos> originArea = BlockPos.m_121886_((int)-1, (int)-1, (int)-1, (int)1, (int)1, (int)1).map(BlockPos::m_7949_).toList();
    public static Predicate<BlockState> isPowerProvider = state -> state.m_60734_() instanceof IEnchantmentPowerProvider || state.m_204336_(BlockTags.f_278384_);

    public static float getPowerFromBlock(Level world, BlockPos pos, BlockState state) {
        Block block = state.m_60734_();
        if (block instanceof IEnchantmentPowerProvider) {
            IEnchantmentPowerProvider provider = (IEnchantmentPowerProvider)block;
            return provider.getEnchantmentPower(world, pos, state);
        }
        if (state.m_204336_(BlockTags.f_278384_)) {
            return 1.0f;
        }
        return 0.0f;
    }

    public static boolean canBlockPath(Level world, BlockPos pos, Configs.obstructionType obType) {
        if (Configs.enableAllowList && Configs.allowList.contains(Objects.requireNonNull(world.m_8055_(pos).m_60734_().arch$registryName()).toString())) {
            return false;
        }
        if (Configs.enableDenyList && Configs.denyList.contains(Objects.requireNonNull(world.m_8055_(pos).m_60734_().arch$registryName()).toString())) {
            return true;
        }
        if (obType == Configs.obstructionType.SOLID) {
            return world.m_8055_(pos).m_60838_((BlockGetter)world, pos);
        }
        if (obType == Configs.obstructionType.DEFAULT) {
            return !world.m_8055_(pos).m_204336_(BlockTags.f_278486_);
        }
        return false;
    }

    public static float getPowerFromArea(Level world, BlockPos origin, List<BlockPos> providers, Configs.obstructionType obstructionType2, Boolean getMoreShelves) {
        float power = 0.0f;
        BlockPos.MutableBlockPos shelfPos = new BlockPos.MutableBlockPos();
        for (BlockPos shelfOffset : EnchantmentPowerUtil.getPowerProvidersInArea(world, origin, providers, obstructionType2, getMoreShelves)) {
            shelfPos.m_175306_((Vec3i)origin, (Vec3i)shelfOffset);
            power += EnchantmentPowerUtil.getPowerFromBlock(world, (BlockPos)shelfPos, world.m_8055_((BlockPos)shelfPos));
        }
        return power;
    }

    public static float getPowerFromProviders(Level world, BlockPos origin, List<BlockPos> providers) {
        float power = 0.0f;
        BlockPos.MutableBlockPos shelfPos = new BlockPos.MutableBlockPos();
        for (BlockPos shelfOffset : providers) {
            shelfPos.m_175306_((Vec3i)origin, (Vec3i)shelfOffset);
            power += EnchantmentPowerUtil.getPowerFromBlock(world, (BlockPos)shelfPos, world.m_8055_((BlockPos)shelfPos));
        }
        return power;
    }

    public static List<BlockPos> getPowerProvidersInArea(Level world, BlockPos origin, List<BlockPos> areaToSearch, Configs.obstructionType obType, boolean getMoreShelves) {
        ArrayList<BlockPos> knownShelves = new ArrayList<BlockPos>();
        for (BlockPos maxSearchPos : areaToSearch) {
            BlockPos.MutableBlockPos searchOffset = originArea.stream().sorted(Comparator.comparing(arg_0 -> ((BlockPos)maxSearchPos).m_123333_(arg_0))).toList().get(0).m_122032_();
            EnchantmentPowerUtil.searchForShelf(world, origin, maxSearchPos, searchOffset, knownShelves, getMoreShelves, obType);
        }
        return knownShelves;
    }

    private static void searchForShelf(Level world, BlockPos origin, BlockPos maxSearchPos, BlockPos.MutableBlockPos searchOffset, List<BlockPos> knownShelves, Boolean getMoreShelves, Configs.obstructionType obType) {
        BlockPos.MutableBlockPos searchPos = new BlockPos.MutableBlockPos();
        searchPos.m_175306_((Vec3i)origin, (Vec3i)searchOffset);
        searchOffset.m_142448_(maxSearchPos.m_123342_());
        if (EnchantmentPowerUtil.canBlockPath(world, (BlockPos)searchPos, obType)) {
            return;
        }
        while (searchOffset.m_123341_() != maxSearchPos.m_123341_() || searchOffset.m_123343_() != maxSearchPos.m_123343_()) {
            if (searchOffset.m_123341_() != maxSearchPos.m_123341_()) {
                searchOffset.m_142451_(EnchantmentPowerUtil.moveByOneAdd(searchOffset.m_123341_()));
            }
            if (searchOffset.m_123343_() != maxSearchPos.m_123343_()) {
                searchOffset.m_142443_(EnchantmentPowerUtil.moveByOneAdd(searchOffset.m_123343_()));
            }
            if (knownShelves.contains(searchOffset)) {
                if (!getMoreShelves.booleanValue()) break;
                continue;
            }
            searchPos.m_175306_((Vec3i)origin, (Vec3i)searchOffset);
            if (isPowerProvider.test(world.m_8055_((BlockPos)searchPos))) {
                knownShelves.add(searchOffset.m_7949_());
                if (!getMoreShelves.booleanValue()) break;
                continue;
            }
            if (!EnchantmentPowerUtil.canBlockPath(world, (BlockPos)searchPos, obType)) continue;
            break;
        }
    }

    public static boolean isPathObstructed(Level world, BlockPos origin, BlockPos.MutableBlockPos providerOffset, Configs.obstructionType type) {
        if (type == Configs.obstructionType.NONE) {
            return false;
        }
        BlockPos.MutableBlockPos searchPos = new BlockPos.MutableBlockPos();
        BlockPos closestBlockToOrigin = originArea.stream().sorted(Comparator.comparing(arg_0 -> ((BlockPos.MutableBlockPos)providerOffset).m_123333_(arg_0))).toList().get(0);
        while (providerOffset.m_123343_() != closestBlockToOrigin.m_123343_() || providerOffset.m_123341_() != closestBlockToOrigin.m_123341_()) {
            if (providerOffset.m_123341_() != closestBlockToOrigin.m_123341_()) {
                providerOffset.m_142451_(EnchantmentPowerUtil.moveByOneSub(providerOffset.m_123341_()));
            }
            if (providerOffset.m_123343_() != closestBlockToOrigin.m_123343_()) {
                providerOffset.m_142443_(EnchantmentPowerUtil.moveByOneSub(providerOffset.m_123343_()));
            }
            if (Math.abs(providerOffset.m_123342_()) > 2) {
                providerOffset.m_142448_(EnchantmentPowerUtil.moveByOneSub(providerOffset.m_123342_()));
            }
            searchPos.m_175306_((Vec3i)origin, (Vec3i)providerOffset);
            if (type == Configs.obstructionType.SOLID && world.m_8055_((BlockPos)searchPos).m_60838_((BlockGetter)world, (BlockPos)searchPos)) {
                return true;
            }
            if (type != Configs.obstructionType.DEFAULT || world.m_8055_((BlockPos)searchPos).m_204336_(BlockTags.f_278486_)) continue;
            return true;
        }
        return false;
    }

    private static int moveByOneSub(int pos) {
        return pos - pos / Math.abs(pos);
    }

    private static int moveByOneAdd(int pos) {
        return pos + pos / Math.abs(pos);
    }
}

