package net.pneumono.pneumonocore.config_api.screen.entries;

import net.pneumono.pneumonocore.config_api.screen.ConfigOptionsScreen;
import net.pneumono.pneumonocore.config_api.screen.widgets.ConfigsListWidget;
import net.minecraft.class_332;
import net.pneumono.pneumonocore.config_api.configurations.BoundedFloatConfiguration;
import net.pneumono.pneumonocore.config_api.screen.widgets.FloatConfigSliderWidget;

public class BoundedFloatConfigurationEntry extends AbstractConfigurationEntry<Float, BoundedFloatConfiguration> {
    private final FloatConfigSliderWidget sliderWidget;

    public BoundedFloatConfigurationEntry(ConfigOptionsScreen parent, ConfigsListWidget widget, BoundedFloatConfiguration configuration) {
        super(parent, widget, configuration);

        this.sliderWidget = addChild(new FloatConfigSliderWidget(
                (slider, configValue) -> setValue(configValue),
                this.value, 0, 0, getTotalWidgetWidth(), 20
        ));
    }

    @Override
    public void updateWidgets() {
        this.sliderWidget.setValue(this.value);
    }

    @Override
    //? if >=1.21.9 {
    /*public void render(DrawContext context, int mouseX, int mouseY, boolean hovered, float tickDelta) {
        super.render(context, mouseX, mouseY, hovered, tickDelta);
        int x = getX();
        int y = getY();
    *///?} else {
    public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
        super.method_25343(context, index, y, x, entryWidth, entryHeight, mouseX, mouseY, hovered, tickDelta);
    //?}

        this.sliderWidget.method_46421(x + getWidgetStartX());
        this.sliderWidget.method_46419(y);
        this.sliderWidget.method_25394(context, mouseX, mouseY, tickDelta);
    }
}
