package net.pneumono.pneumonocore.datagen;

import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricDynamicRegistryProvider;
import net.minecraft.class_1792;
import net.minecraft.class_1887;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_7871;
import net.minecraft.class_7891;
import net.minecraft.class_7924;
import net.minecraft.registry.*;

import java.util.Map;
import java.util.concurrent.CompletableFuture;

/**
 * Provider for datagen of enchantments. Should not be used <1.21.1, for obvious reasons
 *
 * <p>Subclasses must extend {@link #getEnchantmentBuilders}.
 *
 * <p>This may also need to be bootstrapped, by calling {@link #bootstrap} in {@link DataGeneratorEntrypoint#buildRegistry}
 */
@SuppressWarnings("unused")
public abstract class PneumonoCoreEnchantmentProvider extends FabricDynamicRegistryProvider {
    public PneumonoCoreEnchantmentProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
        super(output, registriesFuture);
    }

    //? if >=1.21.1 {
    public static Map<class_5321<class_1887>, class_1887.class_9700> getEnchantmentBuilders(class_7871<class_1792> itemLookup) {
        throw new IllegalStateException("getEnchantmentBuilders must be overridden");
    }
    //?} else {
    /*public static Map<RegistryKey<Enchantment>, Enchantment> getEnchantmentBuilders(RegistryEntryLookup<Item> itemLookup) {
        throw new UnsupportedOperationException("PneumonoCoreEnchantmentProvider cannot be used in versions without data-driven enchantments");
    }
    *///?}

    @Override
    protected void configure(class_7225.class_7874 registries, Entries entries) {
        //? if >=1.21.3 {
        /*RegistryWrapper.Impl<Item> itemLookup = registries.getOrThrow(RegistryKeys.ITEM);
        *///?} else {
        class_7225.class_7226<class_1792> itemLookup = registries.method_46762(class_7924.field_41197);
        //?}

        //? if >=1.21.1 {
        for (Map.Entry<class_5321<class_1887>, class_1887.class_9700> entry : getEnchantmentBuilders(itemLookup).entrySet()) {
            entries.add(entry.getKey(), entry.getValue().method_60060(entry.getKey().method_29177()));
        }
        //?}
    }

    public static void bootstrap(class_7891<class_1887> registry) {
        //? if >=1.21.1 {
        class_7871<class_1792> itemLookup = registry.method_46799(class_7924.field_41197);

        for (Map.Entry<class_5321<class_1887>, class_1887.class_9700> entry : getEnchantmentBuilders(itemLookup).entrySet()) {
            registry.method_46838(entry.getKey(), entry.getValue().method_60060(entry.getKey().method_29177()));
        }
        //?}
    }

    @Override
    public String method_10321() {
        return "Enchantments";
    }
}
