package net.pneumono.pneumonocore.config_api;

import net.minecraft.class_2960;
import net.pneumono.pneumonocore.config_api.configurations.AbstractConfiguration;
import net.pneumono.pneumonocore.config_api.screen.entries.AbstractConfigurationEntry;
import net.pneumono.pneumonocore.config_api.screen.entries.ErroneousConfigurationEntry;
import net.pneumono.pneumonocore.config_api.screen.ConfigOptionsScreen;
import net.pneumono.pneumonocore.config_api.screen.components.ConfigsList;

import java.util.HashMap;
import java.util.Map;

public final class ClientConfigApi {
    private static final Map<class_2960, EntryFactory> CONFIG_ENTRY_TYPES = new HashMap<>();

    /**
     * Registers a builder for a class extending {@link AbstractConfigurationEntry}.
     *
     * <p>The ID should be the same one returned by {@link AbstractConfiguration.Info#getConfigTypeId()}.
     * You most likely need to cast the abstract configuration to your preferred subclass,
     * this can be done using an instanceof check and returning null otherwise.
     *
     * <p>Returning null is completely fine,
     * and the config screen will simply use an {@linkplain ErroneousConfigurationEntry erroneous entry} in its place.
     *
     * <p>See {@link ClientConfigApiRegistry} for examples.
     */
    public static void registerConfigEntryType(class_2960 id, EntryFactory builder) {
        CONFIG_ENTRY_TYPES.put(id, builder);
    }

    public static EntryFactory getConfigEntryType(class_2960 id) {
        return CONFIG_ENTRY_TYPES.getOrDefault(id, (EntryFactory) ErroneousConfigurationEntry::new);
    }

    @FunctionalInterface
    public interface EntryFactory {
        AbstractConfigurationEntry<?, ?> build(ConfigOptionsScreen parent, ConfigsList widget, AbstractConfiguration<?> configuration);
    }
}
