package net.pneumono.pneumonocore.config_api;

import com.mojang.brigadier.arguments.StringArgumentType;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.pneumono.pneumonocore.config_api.configurations.AbstractConfiguration;
import net.pneumono.pneumonocore.config_api.registry.ConfigSuggestionProvider;

import static net.fabricmc.fabric.api.client.command.v2.ClientCommandManager.argument;
import static net.fabricmc.fabric.api.client.command.v2.ClientCommandManager.literal;

@SuppressWarnings("unused")
public final class ClientConfigCommandRegistry {
    public static void registerClientConfigCommand(String modId, String commandName) {
        ConfigSuggestionProvider<FabricClientCommandSource> configSuggestionProvider =
                new ConfigSuggestionProvider<>(modId);

        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) ->
                dispatcher.register(literal(commandName)
                        .then(literal("get")
                                .then(argument("config", StringArgumentType.string())
                                        .suggests(configSuggestionProvider)
                                        .executes(context -> {
                                            context.getSource().sendFeedback(class_2561.method_43470(getConfigValueString(
                                                    modId, StringArgumentType.getString(context, "config")
                                            )).method_27692(class_124.field_1075));

                                            return 1;
                                        })
                                )
                        )
                )
        );
    }

    public static String getConfigValueString(String modId, String name) {
        ConfigFile modConfigs = ConfigApi.getConfigFile(modId);
        if (modConfigs != null) {
            AbstractConfiguration<?> config = modConfigs.getConfiguration(name);
            if (config != null) {
                return config.info().getModId() + ":" + config.info().getName() + " is set to " + config.getValue().toString();
            }
        }
        return modId + ":" + name + " does not exist!";
    }
}
