package net.pneumono.pneumonocore.config_api;

import net.minecraft.class_2487;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.pneumono.pneumonocore.config_api.configurations.AbstractConfiguration;
import net.pneumono.pneumonocore.util.MultiVersionUtil;
import java.util.Collection;
import net.pneumono.pneumonocore.config_api.registry.ConfigApiRegistry;
import org.jetbrains.annotations.NotNull;
//?}

/**
 * Only used as an actual payload >=1.20.5
 */
public record ConfigSyncS2CPayload(class_2487 storedValues) /*? if >=1.20.5 {*/implements class_8710/*?}*/ {
    //? if >=1.20.5 {
    public static final class_9154<ConfigSyncS2CPayload> TYPE = new class_9154<>(ConfigApiRegistry.CONFIG_SYNC_ID);
    public static final class_9139<class_9129, ConfigSyncS2CPayload> CODEC = class_9139.method_56434(
            class_9135.field_48556,
            ConfigSyncS2CPayload::storedValues,
            ConfigSyncS2CPayload::new
    );

    @Override
    public @NotNull class_9154<? extends ConfigSyncS2CPayload> method_56479() {
        return TYPE;
    }

    public ConfigSyncS2CPayload(Collection<ConfigFile> configFiles) {
        this(toNbt(configFiles));
    }
    //?}

    public static class_2487 toNbt(Collection<ConfigFile> configFiles) {
        class_2487 compound = new class_2487();
        for (ConfigFile configFile : configFiles) {

            class_2487 fileNbt = new class_2487();
            for (AbstractConfiguration<?> config : configFile.getConfigurations()) {
                putConfigValue(fileNbt, config);
            }
            compound.method_10566(configFile.getModId(), fileNbt);
        }
        return compound;
    }

    private static <T> void putConfigValue(class_2487 compound, AbstractConfiguration<T> config) {
        MultiVersionUtil.putObjectWithCodec(compound, config.info().getName(), config.getValueCodec(), config.getValue());
    }
}
