package net.pneumono.pneumonocore.config_api.screen;

import net.pneumono.pneumonocore.config_api.screen.components.ConfigsList;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_8012;
import net.pneumono.pneumonocore.config_api.configurations.AbstractConfiguration;
import net.pneumono.pneumonocore.config_api.screen.entries.AbstractConfigListEntry;
import net.pneumono.pneumonocore.config_api.screen.entries.AbstractConfigurationEntry;

import java.util.Objects;

public abstract class ConfigOptionsScreen extends class_437 {
    public final class_437 lastScreen;
    public final String modId;

    public ConfigsList configsList;

    public ConfigOptionsScreen(class_437 lastScreen, String modId) {
        super(class_2561.method_43471("configs." + modId + ".screen_title"));
        this.lastScreen = lastScreen;
        this.modId = modId;
    }

    public abstract <T> T getConfigValue(AbstractConfiguration<T> configuration);

    public abstract <T, C extends AbstractConfiguration<T>> void setSavedValue(AbstractConfigurationEntry<T, C> entry);

    public abstract void writeSavedValues();

    @Override
    protected void method_25426() {
        this.initBody();
        this.initFooter();
        this.configsList.method_25307(0);
    }

    protected void initBody() {
        this.configsList = this.method_37063(new ConfigsList(this));
        this.configsList.init();
    }

    protected void initFooter() {
        this.method_37063(class_4185.method_46430(class_2561.method_43471("configs_screen.pneumonocore.reset_all"), button -> {
            for (AbstractConfigListEntry entry : configsList.method_25396()) {
                if (entry instanceof AbstractConfigurationEntry<?, ?> configurationEntry) {
                    configurationEntry.reset();
                }
            }

            this.configsList.updateEntryList();
            this.configsList.updateEntryValues();
        }).method_46434((this.field_22789 / 2) - 154, this.field_22790 - 28, 150, 20).method_46431());

        this.method_37063(class_4185.method_46430(class_5244.field_24334, button -> {
            for (AbstractConfigListEntry entry : configsList.getEntries()) {
                if (entry instanceof AbstractConfigurationEntry<?, ?> configurationEntry && configurationEntry.shouldSaveValue()) {
                    setSavedValue(configurationEntry);
                }
            }

            this.writeSavedValues();
            Objects.requireNonNull(this.field_22787).method_1507(this.lastScreen);
        }).method_46434((this.field_22789 / 2) + 4, this.field_22790 - 28, 150, 20).method_46431());
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        //? if <1.20.2 {
        /*this.renderBackground(graphics);
        *///?}
        super.method_25394(graphics, mouseX, mouseY, delta);
        graphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 10, class_8012.field_42973);
    }

    public int getContentHeight() {
        return this.field_22790 - this.getHeaderHeight() - this.getFooterHeight();
    }

    public int getHeaderHeight() {
        return 36;
    }

    public int getFooterHeight() {
        return 36;
    }

    public class_310 getMinecraft() {
        return this.field_22787;
    }
}
