package net.pneumono.pneumonocore.config_api.screen.components;

import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_357;

public class IntegerConfigSliderButton extends class_357 {
    private final SliderChangeAction action;
    private final int min;
    private final int max;

    public IntegerConfigSliderButton(SliderChangeAction action, int value, int min, int max, int x, int y, int width, int height) {
        super(x, y, width, height, class_2561.method_43470(Integer.toString(value)), toPercentage(value, min, max));
        this.action = action;
        this.min = min;
        this.max = max;
    }

    @Override
    protected void method_25346() {
        method_25355(class_2561.method_43470(Integer.toString(fromPercentage(this.field_22753, this.min, this.max))));
    }

    @Override
    protected void method_25344() {
        this.action.onChange(this, fromPercentage(this.field_22753, this.min, this.max));
    }

    public void setValue(int value) {
        this.field_22753 = toPercentage(class_3532.method_15340(value, this.min, this.max), this.min, this.max);
        method_25346();
    }

    private static double toPercentage(int value, int min, int max) {
        return (value - min) / (double)(max - min);
    }

    private static int fromPercentage(double value, int min, int max) {
        return (int)Math.round((value * (max - min)) + min);
    }

    public interface SliderChangeAction {
        void onChange(IntegerConfigSliderButton widget, int value);
    }
}
