package net.pneumono.pneumonocore.config_api.screen.entries;

import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_7919;
import net.minecraft.class_8012;
import net.minecraft.class_8662;
import net.pneumono.pneumonocore.PneumonoCore;
import net.pneumono.pneumonocore.config_api.ConfigApi;
import net.pneumono.pneumonocore.config_api.configurations.AbstractConfiguration;
import net.pneumono.pneumonocore.config_api.screen.ConfigOptionsScreen;
import net.pneumono.pneumonocore.config_api.screen.components.ConfigsList;
import java.util.Objects;

public abstract class AbstractConfigurationEntry<T, C extends AbstractConfiguration<T>> extends AbstractConfigListEntry {
    protected final ConfigsList widget;
    protected final C configuration;
    protected final /*? if >=1.20.2 {*/class_8662/*?} else {*/ /*ImageButton*//*?}*/ resetWidget;

    protected T value;

    public AbstractConfigurationEntry(ConfigOptionsScreen parent, ConfigsList widget, C configuration) {
        super(parent);
        this.widget = widget;
        this.configuration = configuration;
        this.resetWidget = addChild(
                //? if >=1.20.2 {
                class_8662.method_52723(
                        class_2561.method_43471("configs_screen.pneumonocore.reset"),
                        button -> this.reset(),
                        true
                )
                .method_52727(PneumonoCore.location("icon/reset"), 15, 15)
                .method_52725(20).method_52724()
                //?} else {
                /*new ImageButton(
                        0, 0,
                        20, 20,
                        0, 0,
                        20,
                        PneumonoCore.location("textures/gui/sprites/icon/reset_button.png"),
                        20,
                        40,
                        button -> this.reset()
                )
                *///?}
        );

        this.resetWidget.method_47400(class_7919.method_47407(
                class_2561.method_43471("configs_screen.pneumonocore.reset")
        ));

        this.value = this.parent.getConfigValue(this.configuration);
    }

    public C getConfiguration() {
        return configuration;
    }

    public T getValue() {
        return value;
    }

    public void setValue(T value) {
        this.value = value;
        this.widget.updateEntryList();
        this.updateButtons();
    }

    public void reset() {
        setValue(this.configuration.info().getDefaultValue());
    }

    @Override
    public boolean shouldDisplay() {
        AbstractConfiguration<?> configParent = this.configuration.info().getParent();
        if (configParent == null) return true;
        AbstractConfigurationEntry<?, ?> configParentEntry = this.widget.getEntry(configParent.info().getId());
        if (configParentEntry == null) return true;
        return this.configuration.info().isEnabled(configParentEntry.value);
    }

    public int getWidgetStartX() {
        return this.getRowEndXOffset() - 136;
    }

    public int getWidgetEndX() {
        return this.getRowEndXOffset() - this.resetWidget.method_25368() - 6;
    }

    public int getTotalWidgetWidth() {
        return this.getWidgetEndX() - this.getWidgetStartX();
    }

    @Override
    //? if >=1.21.9 {
    /*public void renderContent(GuiGraphics graphics, int mouseX, int mouseY, boolean hovered, float tickProgress) {
        int x = getX();
        int y = getY();
        int entryHeight = getContentHeight();
    *///?} else {
    public void method_25343(class_332 graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickProgress) {
    //?}
        class_2561 configName = class_2561.method_43471(ConfigApi.toTranslationKey(this.configuration));
        class_327 font = Objects.requireNonNull(this.parent.getMinecraft()).field_1772;
        graphics.method_27535(font, configName, x, (y + entryHeight / 2) - 2, class_8012.field_42973);

        if (mouseX >= x && mouseX <= x + 135 && mouseY >= y && mouseY <= y + entryHeight) {
            //? if >=1.21.6 {
            /*graphics.setTooltipForNextFrame(
            *///?} else {
            graphics.method_51447(
            //?}
                    font,

                    font.method_1728(
                            class_2561.method_43471(ConfigApi.toTranslationKey(configuration, "tooltip"))
                                    .method_27693("\n\n")
                                    .method_10852(class_2561.method_43471(configuration.info().isClientSided() ?
                                            "configs_screen.pneumonocore.client" :
                                            "configs_screen.pneumonocore.server"
                                    ).method_27692(class_124.field_1080))
                                    .method_27693("\n")
                                    .method_10852(class_2561.method_43471(switch (configuration.info().getLoadType()) {
                                        case INSTANT -> "configs_screen.pneumonocore.load_instant";
                                        case RELOAD -> "configs_screen.pneumonocore.load_reload";
                                        case RESTART -> "configs_screen.pneumonocore.load_restart";
                                    }).method_27692(class_124.field_1080)),
                            250
                    ),

                    mouseX, mouseY
            );
        }

        this.resetWidget.method_46421(x + getRowEndXOffset() - this.resetWidget.method_25368());
        this.resetWidget.method_46419(y);
        this.resetWidget.method_25394(graphics, mouseX, mouseY, tickProgress);
    }

    /**
     * @return Whether this value should be saved when the Save button is pressed.
     *
     * <p>Should return false if the value is invalid.
     * (e.g. a text field widget for integers where a non-integer value has been entered)
     */
    public boolean shouldSaveValue() {
        return true;
    }
}
