package net.pneumono.pneumonocore.config_api.screen.entries;

import net.pneumono.pneumonocore.config_api.screen.ConfigOptionsScreen;
import net.pneumono.pneumonocore.config_api.screen.components.IntegerConfigSliderButton;
import net.pneumono.pneumonocore.config_api.screen.components.ConfigsList;
import net.minecraft.class_332;
import net.pneumono.pneumonocore.config_api.configurations.BoundedIntegerConfiguration;

public class BoundedIntegerConfigurationEntry extends AbstractConfigurationEntry<Integer, BoundedIntegerConfiguration> {
    private final IntegerConfigSliderButton sliderButton;

    public BoundedIntegerConfigurationEntry(ConfigOptionsScreen parent, ConfigsList widget, BoundedIntegerConfiguration configuration) {
        super(parent, widget, configuration);
        int minValue = configuration.getMinValue();
        int maxValue = configuration.getMaxValue();

        this.sliderButton = addChild(new IntegerConfigSliderButton(
                (slider, configValue) -> setValue(configValue),
                this.value, minValue, maxValue, 0, 0, getTotalWidgetWidth(), 20
        ));
    }

    @Override
    public void updateButtons() {
        this.sliderButton.setValue(this.value);
    }

    @Override
    //? if >=1.21.9 {
    /*public void renderContent(GuiGraphics graphics, int mouseX, int mouseY, boolean hovered, float tickDelta) {
        super.renderContent(graphics, mouseX, mouseY, hovered, tickDelta);
        int x = getX();
        int y = getY();
    *///?} else {
    public void method_25343(class_332 graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
        super.method_25343(graphics, index, y, x, entryWidth, entryHeight, mouseX, mouseY, hovered, tickDelta);
    //?}

        this.sliderButton.method_46421(x + getWidgetStartX());
        this.sliderButton.method_46419(y);
        this.sliderButton.method_25394(graphics, mouseX, mouseY, tickDelta);
    }
}
