package net.pneumono.pneumonocore.config_api.screen.entries;

import net.pneumono.pneumonocore.config_api.screen.ConfigOptionsScreen;
import net.pneumono.pneumonocore.config_api.screen.components.ConfigsList;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_7919;
import net.pneumono.pneumonocore.config_api.configurations.TimeConfiguration;
import net.pneumono.pneumonocore.config_api.enums.TimeUnit;
import net.pneumono.pneumonocore.util.PneumonoCoreUtil;

public class TimeConfigurationEntry extends EditBoxConfigurationEntry<Long, TimeConfiguration, Long> {
    private final class_4185 cycleButton;
    private TimeUnit units;
    private long amount;

    public TimeConfigurationEntry(ConfigOptionsScreen parent, ConfigsList widget, TimeConfiguration configuration) {
        super(parent, widget, configuration, -25);

        this.amount = getAmount(this.value);
        this.units = TimeUnit.fromValue(this.value);

        this.cycleButton = addChild(class_4185.method_46430(class_2561.method_43470(""), (button) -> {
            this.units = PneumonoCoreUtil.cycleEnum(this.units);
            setValue(this.amount * this.units.getDivision());
        }).method_46434(0, 0, 20, 20).method_46431());
    }

    @Override
    public Long textGetValue() {
        return this.amount;
    }

    @Override
    public void textSetValue(Long value) {
        this.amount = value;
        this.setValue(value * this.units.getDivision());
    }

    @Override
    public String stringFromValue(Long value) {
        return Long.toString(value);
    }

    @Override
    public Long valueFromString(String string) {
        try {
            return Long.parseLong(string);
        } catch (NumberFormatException e) {
            return null;
        }
    }

    private long getAmount(long value) {
        return value / TimeUnit.fromValue(value).getDivision();
    }

    @Override
    public void updateButtons() {
        super.updateButtons();

        try {
            this.amount = Long.parseLong(this.editBox.method_1882());
        } catch (NumberFormatException ignored) {}

        String key = "configs_screen.pneumonocore." + this.units.name().toLowerCase();
        this.cycleButton.method_25355(class_2561.method_43471(key));
        this.cycleButton.method_47400(class_7919.method_47407(class_2561.method_43471(key + ".full")));
    }

    @Override
    public void reset() {
        this.amount = getAmount(configuration.info().getDefaultValue());
        this.units = TimeUnit.fromValue(configuration.info().getDefaultValue());
        super.reset();
    }

    @Override
    //? if >=1.21.9 {
    /*public void renderContent(GuiGraphics graphics, int mouseX, int mouseY, boolean hovered, float tickDelta) {
        super.renderContent(graphics, mouseX, mouseY, hovered, tickDelta);
        int x = getX();
        int y = getY();
    *///?} else {
    public void method_25343(class_332 graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
        super.method_25343(graphics, index, y, x, entryWidth, entryHeight, mouseX, mouseY, hovered, tickDelta);
    //?}

        this.cycleButton.method_46421(x + getWidgetEndX() - this.cycleButton.method_25368());
        this.cycleButton.method_46419(y);
        this.cycleButton.method_25394(graphics, mouseX, mouseY, tickDelta);
    }
}
