package net.pneumono.pneumonocore.datagen;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_175;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1869;
import net.minecraft.class_1935;
import net.minecraft.class_2119;
import net.minecraft.class_2960;
import net.minecraft.class_5797;
import net.minecraft.class_6862;
import net.minecraft.class_7800;
import net.minecraft.class_7871;
import net.minecraft.class_8782;
import net.minecraft.class_8790;
import net.minecraft.class_8957;
import net.pneumono.pneumonocore.util.MultiVersionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

// Mostly boilerplate from ShapedRecipeBuilder
// Allows using ItemStacks as results
// Do not use <1.20.3
@SuppressWarnings("unused")
public class ShapedStackRecipeBuilder /*? if >=1.20.2 {*/implements class_5797/*?}*/ {
    private final class_7871<class_1792> registryLookup;
    private final class_7800 category;
    private final class_1799 output;
    private final List<String> pattern = Lists.newArrayList();
    private final Map<Character, class_1856> inputs = Maps.newLinkedHashMap();
    //? if >=1.20.2 {
    private final Map<String, class_175<?>> criteria = new LinkedHashMap<>();
    //?}
    @Nullable
    private String group;
    private boolean showNotification = true;

    private ShapedStackRecipeBuilder(class_7871<class_1792> registryLookup, class_7800 category, class_1799 output) {
        this.registryLookup = registryLookup;
        this.category = category;
        this.output = output;
    }

    public static ShapedStackRecipeBuilder create(class_7871<class_1792> registryLookup, class_7800 category, class_1799 output) {
        return new ShapedStackRecipeBuilder(registryLookup, category, output);
    }

    public ShapedStackRecipeBuilder input(Character c, class_6862<class_1792> tag) {
        //? if >=1.21.2 {
        /*return this.input(c, Ingredient.of(this.registryLookup.getOrThrow(tag)));
        *///?} else {
        return this.input(c, class_1856.method_8106(tag));
        //?}
    }

    public ShapedStackRecipeBuilder input(Character c, class_1935 item) {
        return this.input(c, class_1856.method_8091(item));
    }

    public ShapedStackRecipeBuilder input(Character c, class_1856 ingredient) {
        if (this.inputs.containsKey(c)) {
            throw new IllegalArgumentException("Symbol '" + c + "' is already defined!");
        } else if (c == ' ') {
            throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
        } else {
            this.inputs.put(c, ingredient);
            return this;
        }
    }

    public ShapedStackRecipeBuilder pattern(String patternStr) {
        if (!this.pattern.isEmpty() && patternStr.length() != MultiVersionUtil.getFirst(this.pattern).length()) {
            throw new IllegalArgumentException("Pattern must be the same width on every line!");
        } else {
            this.pattern.add(patternStr);
            return this;
        }
    }

    //? if >=1.20.2 {
    @Override
    public @NotNull ShapedStackRecipeBuilder method_33530(String string, class_175<?> advancementCriterion) {
        this.criteria.put(string, advancementCriterion);
        return this;
    }
    //?}

    public @NotNull ShapedStackRecipeBuilder method_33529(@Nullable String string) {
        this.group = string;
        return this;
    }

    public ShapedStackRecipeBuilder showNotification(boolean showNotification) {
        this.showNotification = showNotification;
        return this;
    }

    //? if >=1.20.2 {
    @Override
    //?}
    public @NotNull class_1792 method_36441() {
        return this.output.method_7909();
    }

    //? if >=1.20.2 {
    @Override
    //?}
    public void method_17972(
            /*? if >=1.20.2 {*/class_8790 exporter,/*?}*/
            /*? if >=1.21.2 {*//*ResourceKey<Recipe<?>>*//*?} else {*/class_2960/*?}*/ recipeKey
    ) {
        //? if >=1.20.3 {
        class_8957 rawShapedRecipe = this.validate(recipeKey);
        class_161.class_162 builder = exporter.method_53818()
                .method_705("has_the_recipe", class_2119.method_27847(recipeKey))
                .method_703(class_170.class_171.method_753(recipeKey))
                .method_704(class_8782.class_8797.field_1257);
        this.criteria.forEach(builder::method_705);

        class_1869 shapedRecipe = new class_1869(
                Objects.requireNonNullElse(this.group, ""),
                class_5797.method_55308(this.category),
                rawShapedRecipe,
                this.output,
                this.showNotification
        );
        exporter.method_53819(recipeKey, shapedRecipe, builder.method_695(getValue(recipeKey).method_45138("recipes/" + this.category.method_46203() + "/")));
        //?}
    }

    //? if >=1.20.3 {
    private class_8957 validate(
            /*? if >=1.21.2 {*//*ResourceKey<Recipe<?>>*//*?} else {*/class_2960/*?}*/ recipeKey
    ) {
        if (this.criteria.isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + getValue(recipeKey));
        } else {
            return class_8957.method_55085(this.inputs, this.pattern);
        }
    }
    //?}

    private class_2960 getValue(
            /*? if >=1.21.2 {*//*ResourceKey<Recipe<?>>*//*?} else {*/class_2960/*?}*/ recipeKey
    ) {
        //? if >=1.21.11 {
        /*return recipeKey.identifier();
        *///?} else if >=1.21.2 {
        /*return recipeKey.location();
        *///?} else {
        return recipeKey;
        //?}
    }
}
