package net.pneumono.pneumonocore.datagen;

import java.util.Arrays;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2446;
import net.minecraft.class_3981;
import net.minecraft.class_7800;
import net.minecraft.class_8790;

@SuppressWarnings({"unused", "UnusedReturnValue"})
public class StonecuttingRecipeGenerator {
    private final class_2446 recipeProvider;
    private final /*? if >=1.20.2 {*/class_8790/*?} else {*//*Consumer<FinishedRecipe>*//*?}*/ output;
    private final class_7800 defaultCategory;
    private final int[] multipliers;
    private final class_1935[] inputs;

    public StonecuttingRecipeGenerator(
            class_2446 recipeProvider,
            /*? if >=1.20.2 {*/class_8790/*?} else {*//*Consumer<FinishedRecipe>*//*?}*/ output,
            class_1935... inputs
    ) {
        this(recipeProvider, output, class_7800.field_40634, inputs);
    }

    public StonecuttingRecipeGenerator(
            class_2446 recipeProvider,
            /*? if >=1.20.2 {*/class_8790/*?} else {*//*Consumer<FinishedRecipe>*//*?}*/ output,
            class_7800 defaultCategory,
            class_1935... inputs
    ) {
        this(recipeProvider, output, defaultCategory, createDefaultArray(inputs.length), inputs);
    }

    private static int[] createDefaultArray(int size) {
        int[] array = new int[size];
        Arrays.fill(array, 1);
        return array;
    }

    private StonecuttingRecipeGenerator(
            class_2446 recipeProvider,
            /*? if >=1.20.2 {*/class_8790/*?} else {*//*Consumer<FinishedRecipe>*//*?}*/ output,
            class_7800 defaultCategory,
            int[] multipliers, class_1935... inputs
    ) {
        this.recipeProvider = recipeProvider;
        this.output = output;
        this.defaultCategory = defaultCategory;
        this.multipliers = multipliers;
        this.inputs = inputs;
    }

    public StonecuttingRecipeGenerator recipe(class_1935 result) {
        return recipe(this.defaultCategory, result, 1);
    }

    public StonecuttingRecipeGenerator recipe(class_1935 result, int count) {
        return recipe(this.defaultCategory, result, count);
    }

    public StonecuttingRecipeGenerator recipe(class_7800 category, class_1935 result) {
        return recipe(category, result, 1);
    }

    public StonecuttingRecipeGenerator recipe(class_7800 category, class_1935 result, int count) {
        if (count < 1) throw new IllegalArgumentException("Count cannot be <1");

        for (int i = 0; i < this.inputs.length; ++i) {
            class_1935 input = this.inputs[i];
            int finalCount = this.multipliers[i] * count;

            class_3981.method_17969(class_1856.method_8091(input), category, result, finalCount)
                    .method_17970(class_2446.method_32807(input), this.recipeProvider.method_10426(input))
                    .method_36443(this.output, class_2446.method_33714(result, input) + "_stonecutting");
        }

        return this;
    }

    public StonecuttingRecipeGenerator createChild(class_1935 newInput) {
        return createChild(newInput, 1);
    }

    public StonecuttingRecipeGenerator createChild(class_1935 newInput, int count) {
        class_1935[] newInputs = Arrays.copyOf(this.inputs, this.inputs.length + 1);
        newInputs[this.inputs.length] = newInput;

        int[] newMultipliers = Arrays.copyOf(this.multipliers, this.multipliers.length + 1);
        for (int i = 0; i < newMultipliers.length; ++i) {
            newMultipliers[i] = newMultipliers[i] * count;
        }
        newMultipliers[this.multipliers.length] = 1;

        return new StonecuttingRecipeGenerator(this.recipeProvider, this.output, this.defaultCategory, newMultipliers, newInputs);
    }

    public StonecuttingRecipeGenerator createChildWithRecipe(class_1935 newInput) {
        recipe(newInput);
        return createChild(newInput);
    }

    public StonecuttingRecipeGenerator createChildWithRecipe(class_1935 newInput, int count) {
        recipe(newInput, count);
        return createChild(newInput, count);
    }

    public StonecuttingRecipeGenerator createChildWithRecipe(class_7800 category, class_1935 newInput) {
        recipe(category, newInput);
        return createChild(newInput);
    }

    public StonecuttingRecipeGenerator createChildWithRecipe(class_7800 category, class_1935 newInput, int count) {
        recipe(category, newInput, count);
        return createChild(newInput, count);
    }
}
