package net.pneumono.pneumonocore.config_api.screen.entries;

import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4265;
import net.minecraft.class_6379;
import net.pneumono.pneumonocore.config_api.ClientConfigApi;
import net.pneumono.pneumonocore.config_api.screen.ConfigOptionsScreen;

import java.util.ArrayList;
import java.util.List;

/**
 * An entry in a config screen.
 *
 * <p>Entry types can be registered via {@link ClientConfigApi#registerConfigEntryType}
 */
public abstract class AbstractConfigListWidgetEntry extends class_4265.class_4266<AbstractConfigListWidgetEntry> {
    protected final ConfigOptionsScreen parent;
    private final List<class_339> children = new ArrayList<>();

    public AbstractConfigListWidgetEntry(ConfigOptionsScreen parent) {
        this.parent = parent;
    }

    public int getRowEndXOffset() {
        return this.parent.configsListWidget.method_25322() - 2;
    }

    public <T extends class_339> T addChild(T widget) {
        this.children.add(widget);
        return widget;
    }

    @Override
    public List<? extends class_6379> method_37025() {
        return this.children;
    }

    @Override
    public List<? extends class_364> method_25396() {
        return this.children;
    }

    /**
     * Should set all widgets to the value from {@link AbstractConfigurationEntry#value}, if it extends that class.
     */
    public abstract void updateWidgets();

    /**
     * @return Whether this entry should be visible in the entry list.
     */
    public abstract boolean shouldDisplay();
}
