package net.pneumono.pneumonocore.config_api.screen.entries;

import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_5481;
import net.minecraft.class_7919;
import net.pneumono.pneumonocore.config_api.ConfigApi;
import net.pneumono.pneumonocore.config_api.configurations.AbstractConfiguration;
import net.pneumono.pneumonocore.config_api.screen.ConfigOptionsScreen;
import net.pneumono.pneumonocore.config_api.screen.widgets.ConfigsListWidget;
import org.jetbrains.annotations.Nullable;

import java.util.Objects;

public abstract class TextFieldConfigurationEntry<T, C extends AbstractConfiguration<T>, V> extends AbstractConfigurationEntry<T, C> {
    protected final class_342 textWidget;

    public TextFieldConfigurationEntry(ConfigOptionsScreen parent, ConfigsListWidget widget, C configuration) {
        this(parent, widget, configuration, 0);
    }

    public TextFieldConfigurationEntry(ConfigOptionsScreen parent, ConfigsListWidget widget, C configuration, int fieldWidthOffset) {
        super(parent, widget, configuration);

        this.textWidget = addChild(new class_342(
                Objects.requireNonNull(parent.getClient()).field_1772,
                0, 0, getTotalWidgetWidth() + fieldWidthOffset, 20, null,
                class_2561.method_43471(ConfigApi.toTranslationKey(this.configuration))
        ));
        this.textWidget.method_1852(stringFromValue(textGetValue()));
        //? if >=1.21.9 {
        /*this.textWidget.addFormatter(
        *///?} else {
        this.textWidget.method_1854(
        //?}
                (string, firstCharIndex) -> class_5481.method_30747(
                        string, isTextValid(this.textWidget.method_1882()) ? class_2583.field_24360 : class_2583.field_24360.method_27706(class_124.field_1061)
                )
        );
        this.textWidget.method_1863(string -> {
            V value = this.valueFromString(string);
            if (value == null) {
                this.textWidget.method_47400(class_7919.method_47407(class_2561.method_43471("configs_screen.pneumonocore.invalid")));
            } else {
                this.textSetValue(value);
                this.textWidget.method_47400(null);
            }
        });
    }

    public boolean isTextValid(String string) {
        return valueFromString(string) != null;
    }

    public abstract V textGetValue();

    public abstract void textSetValue(V value);

    public abstract String stringFromValue(V value);

    /**
     * Return {@code null} if the string is invalid
     */
    public abstract @Nullable V valueFromString(String string);

    @Override
    public void updateWidgets() {
        V value = textGetValue();
        String valueText = stringFromValue(value);
        if (!Objects.equals(this.textWidget.method_1882(), valueText) && !Objects.equals(valueFromString(this.textWidget.method_1882()), value)) {
            this.textWidget.method_1852(valueText);
        }
    }

    @Override
    //? if >=1.21.9 {
    /*public void render(DrawContext context, int mouseX, int mouseY, boolean hovered, float tickDelta) {
        super.render(context, mouseX, mouseY, hovered, tickDelta);
        int x = getX();
        int y = getY();
    *///?} else {
    public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
        super.method_25343(context, index, y, x, entryWidth, entryHeight, mouseX, mouseY, hovered, tickDelta);
    //?}

        this.textWidget.method_46421(x + getWidgetStartX());
        this.textWidget.method_46419(y);
        this.textWidget.method_25394(context, mouseX, mouseY, tickDelta);
    }

    @Override
    public boolean shouldSaveValue() {
        return isTextValid(this.textWidget.method_1882());
    }
}
