package net.pneumono.pneumonocore.config_api;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.pneumono.pneumonocore.PneumonoCore;
import net.pneumono.pneumonocore.config_api.configurations.*;
import net.pneumono.pneumonocore.config_api.screen.entries.*;
import net.pneumono.pneumonocore.util.MultiVersionUtil;

//? if <1.20.6 {
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.pneumono.pneumonocore.config_api.registry.ConfigApiRegistry;
//?}

public final class ClientConfigApiRegistry {
    public static void register() {
        //? if >=1.20.6 {
        /*ClientPlayNetworking.registerGlobalReceiver(ConfigSyncS2CPayload.ID, ClientConfigApiRegistry::receiveSyncPacket);
        *///?} else {
        ClientPlayNetworking.registerGlobalReceiver(ConfigApiRegistry.CONFIG_SYNC_ID, ClientConfigApiRegistry::receiveSyncPacket);
        //?}

        ClientConfigCommandRegistry.registerClientConfigCommand();

        // Scuffed as hell but couldn't find a better way of doing that so whatever
        registerConfigEntryType("boolean", (parent, widget, configuration) ->
                configuration instanceof BooleanConfiguration booleanConfiguration ?
                        new BooleanConfigurationEntry(parent, widget, booleanConfiguration) : null
        );
        registerConfigEntryType("enum", (parent, widget, configuration) ->
                configuration instanceof EnumConfiguration<?> enumConfiguration ?
                        new EnumConfigurationEntry<>(parent, widget, enumConfiguration) : null
        );
        registerConfigEntryType("integer", (parent, widget, configuration) ->
                configuration instanceof IntegerConfiguration integerConfiguration ?
                        new IntegerConfigurationEntry(parent, widget, integerConfiguration) : null
        );
        registerConfigEntryType("bounded_integer", (parent, widget, configuration) ->
                configuration instanceof BoundedIntegerConfiguration boundedIntegerConfiguration ?
                        new BoundedIntegerConfigurationEntry(parent, widget, boundedIntegerConfiguration) : null
        );
        registerConfigEntryType("float", (parent, widget, configuration) ->
                configuration instanceof FloatConfiguration floatConfiguration ?
                        new FloatConfigurationEntry(parent, widget, floatConfiguration) : null
        );
        registerConfigEntryType("bounded_float", (parent, widget, configuration) ->
                configuration instanceof BoundedFloatConfiguration boundedFloatConfiguration ?
                        new BoundedFloatConfigurationEntry(parent, widget, boundedFloatConfiguration) : null
        );
        registerConfigEntryType("string", (parent, widget, configuration) ->
                configuration instanceof StringConfiguration stringConfiguration ?
                        new StringConfigurationEntry(parent, widget, stringConfiguration) : null
        );
        registerConfigEntryType("validated_string", (parent, widget, configuration) ->
                configuration instanceof ValidatedStringConfiguration validatedStringConfiguration ?
                        new ValidatedStringConfigurationEntry(parent, widget, validatedStringConfiguration) : null
        );
        registerConfigEntryType("time", (parent, widget, configuration) ->
                configuration instanceof TimeConfiguration timeConfiguration ?
                        new TimeConfigurationEntry(parent, widget, timeConfiguration) : null
        );
    }

    private static void registerConfigEntryType(String name, ClientConfigApi.EntryFactory selector) {
        ClientConfigApi.registerConfigEntryType(PneumonoCore.identifier(name), selector);
    }

    //? if >=1.20.6 {
    /*public static void receiveSyncPacket(
            ConfigSyncS2CPayload payload,
            ClientPlayNetworking.Context context
    ) {
        receiveSyncPacket(payload.storedValues());
    }
    *///?} else {
    public static void receiveSyncPacket(
            class_310 client,
            class_634 handler,
            class_2540 buf,
            PacketSender responseSender
    ) {
        receiveSyncPacket(buf.method_10798());
    }
    //?}

    public static void receiveSyncPacket(
            class_2487 nbt
    ) {
        ConfigApi.LOGGER.info("Received config sync packet");

        for (ConfigFile configFile : ConfigApi.getConfigFiles()) {
            class_2487 compound = MultiVersionUtil.getCompound(nbt, configFile.getModId());
            if (compound == null || compound.method_33133()) continue;

            for (AbstractConfiguration<?> configuration : configFile.getConfigurations()) {
                class_2520 element = compound.method_10580(configuration.info().getName());
                if (element == null) continue;

                if (!setReceivedEffectiveValue(configuration, element)) {
                    ConfigApi.LOGGER.warn("Config sync packet contains invalid value '{}' for config '{}'. The default config value will be used instead.", element, configuration.info().getId());
                }
            }
        }
    }

    private static  <T> boolean setReceivedEffectiveValue(AbstractConfiguration<T> config, class_2520 nbtElement) {
        DataResult<Pair<T, class_2520>> result = config.getValueCodec().decode(class_2509.field_11560, nbtElement);
        if (MultiVersionUtil.resultIsError(result)) {
            return false;
        }

        ConfigManager.setEffectiveValue(config, MultiVersionUtil.resultGetOrThrow(result).getFirst());
        return true;
    }
}