/*
 * Decompiled with CFR 0.152.
 */
package net.pneumono.pneumonocore.config_api.configurations;

import com.mojang.serialization.Codec;
import net.minecraft.class_2960;
import net.pneumono.pneumonocore.config_api.configurations.ConfigSettings;
import net.pneumono.pneumonocore.config_api.configurations.ConfigValue;
import net.pneumono.pneumonocore.config_api.enums.LoadType;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractConfiguration<T> {
    private boolean registered = false;
    private class_2960 id;
    private final ConfigSettings settings;
    private final T defaultValue;
    private final ConfigValue<T> savedValue;
    private final ConfigValue<T> effectiveValue;

    public AbstractConfiguration(T defaultValue, ConfigSettings settings) {
        this.settings = settings;
        this.defaultValue = defaultValue;
        this.savedValue = new ConfigValue<T>(this, defaultValue);
        this.effectiveValue = new ConfigValue<T>(this, defaultValue);
    }

    public abstract Codec<T> getValueCodec();

    protected abstract class_2960 getConfigTypeId();

    public T getValue() {
        if (!this.registered) {
            throw new IllegalStateException("Cannot get value of unregistered configuration.");
        }
        boolean enabled = true;
        if (this.settings.condition != null) {
            enabled = this.settings.condition.get();
        }
        if (enabled && this.settings.parent != null) {
            enabled = this.settings.parent.test();
        }
        return enabled ? this.effectiveValue.get() : this.defaultValue;
    }

    public Info info() {
        return new Info();
    }

    protected void register(class_2960 id) {
        this.id = id;
        this.registered = true;
    }

    protected ConfigValue<T> getSavedValue() {
        return this.savedValue;
    }

    protected ConfigValue<T> getEffectiveValue() {
        return this.effectiveValue;
    }

    @Deprecated
    protected void setCategory(String category) {
        this.settings.category(category);
    }

    public class Info {
        public T getDefaultValue() {
            return AbstractConfiguration.this.defaultValue;
        }

        public class_2960 getId() {
            if (!AbstractConfiguration.this.registered) {
                throw new IllegalStateException("Cannot get id of unregistered configuration.");
            }
            return AbstractConfiguration.this.id;
        }

        public String getModId() {
            return this.getId().method_12836();
        }

        public String getName() {
            return this.getId().method_12832();
        }

        public ConfigSettings getSettings() {
            return AbstractConfiguration.this.settings.copy();
        }

        public boolean isClientSided() {
            return this.getSettings().clientSided;
        }

        public String getCategory() {
            return this.getSettings().category;
        }

        public LoadType getLoadType() {
            return this.getSettings().loadType;
        }

        @Nullable
        public AbstractConfiguration<?> getParent() {
            if (this.getSettings().parent != null) {
                return this.getSettings().parent.configuration().get();
            }
            return null;
        }

        public String[] getAliases() {
            return this.getSettings().aliases;
        }

        public boolean isEnabled(Object object) {
            boolean enabled = true;
            if (this.getSettings().condition != null) {
                enabled = this.getSettings().condition.get();
            }
            if (enabled && this.getSettings().parent != null) {
                enabled = this.getSettings().parent.test(object);
            }
            return enabled;
        }

        public class_2960 getConfigTypeId() {
            return AbstractConfiguration.this.getConfigTypeId();
        }
    }
}

