/*
 * Decompiled with CFR 0.152.
 */
package net.pneumono.pneumonocore.config_api.screen.entries;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_7919;
import net.pneumono.pneumonocore.config_api.configurations.TimeConfiguration;
import net.pneumono.pneumonocore.config_api.enums.TimeUnit;
import net.pneumono.pneumonocore.config_api.screen.ConfigOptionsScreen;
import net.pneumono.pneumonocore.config_api.screen.entries.TextFieldConfigurationEntry;
import net.pneumono.pneumonocore.config_api.screen.widgets.ConfigsListWidget;
import net.pneumono.pneumonocore.util.PneumonoCoreUtil;

@Environment(value=EnvType.CLIENT)
public class TimeConfigurationEntry
extends TextFieldConfigurationEntry<Long, TimeConfiguration, Long> {
    private final class_4185 cycleWidget;
    private TimeUnit units;
    private long amount;

    public TimeConfigurationEntry(ConfigOptionsScreen parent, ConfigsListWidget widget, TimeConfiguration configuration) {
        super(parent, widget, configuration, -25);
        this.amount = this.getAmount((Long)this.value);
        this.units = TimeUnit.fromValue((Long)this.value);
        this.cycleWidget = this.addChild(class_4185.method_46430((class_2561)class_2561.method_43470((String)""), button -> {
            this.units = PneumonoCoreUtil.cycleEnum(this.units);
            this.setValue(this.amount * (long)this.units.getDivision());
        }).method_46434(0, 0, 20, 20).method_46431());
    }

    @Override
    public Long textGetValue() {
        return this.amount;
    }

    @Override
    public void textSetValue(Long value) {
        this.amount = value;
        this.setValue(value * (long)this.units.getDivision());
    }

    @Override
    public String stringFromValue(Long value) {
        return Long.toString(value);
    }

    @Override
    public Long valueFromString(String string) {
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private long getAmount(long value) {
        return value / (long)TimeUnit.fromValue(value).getDivision();
    }

    @Override
    public void updateWidgets() {
        super.updateWidgets();
        try {
            this.amount = Long.parseLong(this.textWidget.method_1882());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        String key = "configs_screen.pneumonocore." + this.units.name().toLowerCase();
        this.cycleWidget.method_25355((class_2561)class_2561.method_43471((String)key));
        this.cycleWidget.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)(key + ".full"))));
    }

    @Override
    public void reset() {
        this.amount = this.getAmount((Long)((TimeConfiguration)this.configuration).info().getDefaultValue());
        this.units = TimeUnit.fromValue((Long)((TimeConfiguration)this.configuration).info().getDefaultValue());
        super.reset();
    }

    @Override
    public void method_25343(class_332 context, int mouseX, int mouseY, boolean hovered, float tickDelta) {
        super.method_25343(context, mouseX, mouseY, hovered, tickDelta);
        int x = this.method_46426();
        int y = this.method_46427();
        this.cycleWidget.method_46421(x + this.getWidgetEndX() - this.cycleWidget.method_25368());
        this.cycleWidget.method_46419(y);
        this.cycleWidget.method_25394(context, mouseX, mouseY, tickDelta);
    }
}

