package net.pneumono.pneumonocore.config_api.registry;

import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.pneumono.pneumonocore.config_api.configurations.AbstractConfiguration;
import net.pneumono.pneumonocore.config_api.ConfigApi;
import net.pneumono.pneumonocore.config_api.ConfigFile;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class ServerConfigCommandRegistry {
    public static void registerServerConfigCommand() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) ->
            dispatcher.register(method_9247("serverconfig")
                .requires(source -> source.method_9259(4))
                .then(method_9247("get")
                    .then(method_9244("modid", StringArgumentType.string())
                        .suggests(new ModIdSuggestionProvider())
                        .then(method_9244("config", StringArgumentType.string())
                            .suggests(new ConfigSuggestionProvider())
                            .executes(context -> {
                                context.getSource().method_45068(class_2561.method_43470(getConfigValueString(
                                        StringArgumentType.getString(context, "modid"),
                                        StringArgumentType.getString(context, "config")
                                )).method_27692(class_124.field_1075));

                                return 1;
                            })
                        )
                        .executes(context -> {
                            context.getSource().method_45068(class_2561.method_43470("Configs:"));
                            List<String> configs = getAllConfigValueStrings(StringArgumentType.getString(context, "modid"));
                            if (configs.isEmpty()) {
                                context.getSource().method_45068(class_2561.method_43470("   None!"));
                            } else {
                                for (String config : configs) {
                                    context.getSource().method_45068(class_2561.method_43470("   " + config));
                                }
                            }

                            return 1;
                        })
                    )
                )
            )
        );
    }

    public static List<String> getAllConfigValueStrings(String modId) {
        List<String> returnConfigs = new ArrayList<>();
        ConfigFile modConfigs = ConfigApi.getConfigFile(modId);
        if (modConfigs != null) {
            for (AbstractConfiguration<?> config : modConfigs.getConfigurations()) {
                returnConfigs.add(config.info().getModId() + ":" + config.info().getName() + " is set to " + config.getValue().toString());
            }
        }
        return returnConfigs;
    }

    public static String getConfigValueString(String modId, String name) {
        ConfigFile modConfigs = ConfigApi.getConfigFile(modId);
        if (modConfigs != null) {
            AbstractConfiguration<?> config = modConfigs.getConfiguration(name);
            if (config != null) {
                return config.info().getModId() + ":" + config.info().getName() + " is set to " + config.getValue().toString();
            }
        }
        return modId + ":" + name + " does not exist!";
    }

    public static class ModIdSuggestionProvider implements SuggestionProvider<class_2168> {
        @Override
        public CompletableFuture<Suggestions> getSuggestions(CommandContext<class_2168> context, SuggestionsBuilder builder) {
            for (ConfigFile modConfigs : ConfigApi.getConfigFiles()) {
                if (modConfigs.getModId().toLowerCase().startsWith(builder.getRemainingLowerCase())) {
                    builder.suggest(modConfigs.getModId());
                }
            }

            return builder.buildFuture();
        }
    }

    public static class ConfigSuggestionProvider implements SuggestionProvider<class_2168> {
        @Override
        public CompletableFuture<Suggestions> getSuggestions(CommandContext<class_2168> context, SuggestionsBuilder builder) {
            ConfigFile modConfigs = ConfigApi.getConfigFile(StringArgumentType.getString(context, "modid"));
            if (modConfigs != null) {
                for (AbstractConfiguration<?> config : modConfigs.getConfigurations()) {
                    if (config.info().getName().toLowerCase().startsWith(builder.getRemainingLowerCase())) {
                        builder.suggest(config.info().getName());
                    }
                }
            }

            return builder.buildFuture();
        }
    }
}
