/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.content.diesel_engine;

import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class EngineSoundInstance
extends AbstractTickableSoundInstance {
    private boolean active;
    private int keepAlive;
    private float volumeTarget = 0.5f;
    private float pitchTarget = 0.5f;
    private final float pitchChangeSpeed;

    public EngineSoundInstance(SoundEvent soundEvent, SoundSource soundSource, Vec3 pos, float pitchChangeSpeed) {
        super(soundEvent, soundSource, SoundInstance.createUnseededRandom());
        this.pitchChangeSpeed = pitchChangeSpeed;
        this.looping = true;
        this.active = true;
        this.volume = 0.05f;
        this.pitch = 0.0f;
        this.delay = 0;
        this.keepAlive();
        this.x = pos.x;
        this.y = pos.y;
        this.z = pos.z;
    }

    public void fadeOut() {
        this.active = false;
    }

    public void keepAlive() {
        this.keepAlive = 2;
    }

    public void setPitch(float pitch) {
        this.pitchTarget = pitch;
    }

    public void setVolume(float vol) {
        this.volumeTarget = vol;
    }

    public void tick() {
        if (this.active) {
            this.volume = Mth.lerp((float)0.3f, (float)this.volume, (float)this.volumeTarget);
            this.pitch = Mth.lerp((float)this.pitchChangeSpeed, (float)this.pitch, (float)this.pitchTarget);
            --this.keepAlive;
            if (this.keepAlive == 0) {
                this.fadeOut();
            }
            return;
        }
        this.volume = Math.max(0.0f, this.volume - 0.04f);
        this.pitch = Math.max(0.0f, this.pitch - 0.08f);
        if (this.volume == 0.0f) {
            this.stop();
        }
    }

    public void setPosition(Vec3 pos) {
        this.x = pos.x;
        this.y = pos.y;
        this.z = pos.z;
    }

    public boolean active() {
        return this.active;
    }
}

