/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.content.diesel_engine;

import com.jesz.createdieselgenerators.CDGConfig;
import com.jesz.createdieselgenerators.CDGRegistries;
import com.jesz.createdieselgenerators.content.diesel_engine.EngineUpgrades;
import com.jesz.createdieselgenerators.content.diesel_engine.normal.DieselEngineBlock;
import com.jesz.createdieselgenerators.fuel_type.FuelType;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public interface IEngine {
    default public boolean enabled() {
        if (this.validFS()) {
            return (Boolean)CDGConfig.ENGINES_DISABLED_WITH_REDSTONE.get() == false || (Boolean)this.self().getBlockState().getValue((Property)DieselEngineBlock.POWERED) == false;
        }
        return false;
    }

    default public boolean validFS() {
        if (this.fs().isEmpty()) {
            return false;
        }
        return FuelType.getTypeFor((HolderLookup.RegistryLookup<FuelType>)this.self().getLevel().registryAccess().lookupOrThrow(CDGRegistries.FUEL_TYPE), this.fs().getFluid()) != FuelType.EMPTY;
    }

    default public FluidStack fs() {
        return this.getTank().getFluid();
    }

    default public float getFuelSpeed() {
        return FuelType.getTypeFor((HolderLookup.RegistryLookup<FuelType>)this.self().getLevel().registryAccess().lookupOrThrow(CDGRegistries.FUEL_TYPE), this.fs().getFluid()).getGenerated((BlockEntity)this.self()).speed();
    }

    default public float getFuelCapacity() {
        float speed = this.getFuelSpeed();
        if (speed == 0.0f) {
            return speed;
        }
        return FuelType.getTypeFor((HolderLookup.RegistryLookup<FuelType>)this.self().getLevel().registryAccess().lookupOrThrow(CDGRegistries.FUEL_TYPE), this.fs().getFluid()).getGenerated((BlockEntity)this.self()).strength() / speed;
    }

    default public float getFuelBurnRate() {
        return FuelType.getTypeFor((HolderLookup.RegistryLookup<FuelType>)this.self().getLevel().registryAccess().lookupOrThrow(CDGRegistries.FUEL_TYPE), this.fs().getFluid()).getGenerated((BlockEntity)this.self()).burn();
    }

    default public float getFuelSoundPitch() {
        return FuelType.getTypeFor((HolderLookup.RegistryLookup<FuelType>)this.self().getLevel().registryAccess().lookupOrThrow(CDGRegistries.FUEL_TYPE), this.fs().getFluid()).soundPitch();
    }

    public float getRemainingTicks();

    public SmartBlockEntity self();

    public FluidTank getTank();

    public EngineUpgrades getUpgrade();

    public void setUpgrade(EngineUpgrades var1);
}

