/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.content.entity_filter;

import com.jesz.createdieselgenerators.CreateDieselGenerators;
import com.jesz.createdieselgenerators.content.entity_filter.EntityAttribute;
import com.jesz.createdieselgenerators.content.entity_filter.EntityFilterMenu;
import com.jesz.createdieselgenerators.packets.EntityFilterScreenPacket;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.logistics.filter.AbstractFilterMenu;
import com.simibubi.create.content.logistics.filter.AbstractFilterScreen;
import com.simibubi.create.content.logistics.filter.AttributeFilterWhitelistMode;
import com.simibubi.create.content.logistics.filter.FilterScreenPacket;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.widget.IconButton;
import com.simibubi.create.foundation.gui.widget.Indicator;
import com.simibubi.create.foundation.gui.widget.Label;
import com.simibubi.create.foundation.gui.widget.SelectionScrollInput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.createmod.catnip.gui.element.ScreenElement;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;

public class EntityFilterScreen
extends AbstractFilterScreen<EntityFilterMenu> {
    IconButton whitelistCon;
    IconButton whitelistDis;
    IconButton blacklist;
    IconButton add;
    IconButton addInverted;
    Indicator whitelistConIndicator;
    Indicator whitelistDisIndicator;
    Indicator blacklistIndicator;
    SelectionScrollInput attributeSelector;
    List<Component> selectedAttributes = new ArrayList<Component>();
    List<EntityAttribute> attributesOfItem = new ArrayList<EntityAttribute>();
    Label attributeSelectorLabel;
    ItemStack lastItemScanned = ItemStack.EMPTY;

    public EntityFilterScreen(EntityFilterMenu menu, Inventory inv, Component title) {
        super((AbstractFilterMenu)menu, inv, title, AllGuiTextures.ATTRIBUTE_FILTER);
    }

    protected void init() {
        this.setWindowOffset(-11, 7);
        super.init();
        this.whitelistDis = new IconButton(this.leftPos + 38, this.topPos + 61, (ScreenElement)AllIcons.I_WHITELIST_OR);
        this.whitelistCon = new IconButton(this.leftPos + 56, this.topPos + 61, (ScreenElement)AllIcons.I_WHITELIST_AND);
        this.blacklist = new IconButton(this.leftPos + 74, this.topPos + 61, (ScreenElement)AllIcons.I_WHITELIST_NOT);
        this.whitelistCon.withCallback(() -> {
            ((EntityFilterMenu)this.menu).whitelistMode = AttributeFilterWhitelistMode.WHITELIST_CONJ;
            this.sendOptionUpdate(FilterScreenPacket.Option.WHITELIST2);
        });
        this.whitelistCon.setToolTip(CreateDieselGenerators.lang("gui.entity_filter.allow_list_conjunctive", new Object[0]));
        this.whitelistDis.withCallback(() -> {
            ((EntityFilterMenu)this.menu).whitelistMode = AttributeFilterWhitelistMode.WHITELIST_DISJ;
            this.sendOptionUpdate(FilterScreenPacket.Option.WHITELIST);
        });
        this.whitelistDis.setToolTip(CreateDieselGenerators.lang("gui.entity_filter.allow_list_disjunctive", new Object[0]));
        this.blacklist.withCallback(() -> {
            ((EntityFilterMenu)this.menu).whitelistMode = AttributeFilterWhitelistMode.BLACKLIST;
            this.sendOptionUpdate(FilterScreenPacket.Option.BLACKLIST);
        });
        this.blacklist.setToolTip(CreateDieselGenerators.lang("gui.entity_filter.deny_list", new Object[0]));
        this.addRenderableWidgets((GuiEventListener[])new IconButton[]{this.whitelistCon, this.whitelistDis, this.blacklist});
        this.add = new IconButton(this.leftPos + 182, this.topPos + 26, (ScreenElement)AllIcons.I_ADD);
        this.addRenderableWidget((GuiEventListener)this.add);
        this.addInverted = new IconButton(this.leftPos + 200, this.topPos + 26, (ScreenElement)AllIcons.I_ADD_INVERTED_ATTRIBUTE);
        this.addRenderableWidget((GuiEventListener)this.addInverted);
        this.add.withCallback(() -> this.handleAddedAttribute(false));
        this.add.setToolTip(CreateDieselGenerators.lang("gui.entity_filter.add_attribute", new Object[0]));
        this.addInverted.withCallback(() -> this.handleAddedAttribute(true));
        this.addInverted.setToolTip(CreateDieselGenerators.lang("gui.entity_filter.add_inverted_attribute", new Object[0]));
        this.handleIndicators();
        this.attributeSelectorLabel = new Label(this.leftPos + 43, this.topPos + 31, (Component)Component.empty()).colored(15985630).withShadow();
        this.attributeSelector = new SelectionScrollInput(this.leftPos + 39, this.topPos + 26, 137, 18);
        this.attributeSelector.forOptions(Arrays.asList(Component.empty()));
        this.attributeSelector.removeCallback();
        this.referenceItemChanged(((EntityFilterMenu)this.menu).ghostInventory.getStackInSlot(0));
        this.addRenderableWidget((GuiEventListener)this.attributeSelector);
        this.addRenderableWidget((GuiEventListener)this.attributeSelectorLabel);
        this.selectedAttributes.clear();
        this.selectedAttributes.add((Component)(((EntityFilterMenu)this.menu).selectedAttributes.isEmpty() ? CreateDieselGenerators.lang("gui.entity_filter.no_selected_attributes", new Object[0]) : CreateDieselGenerators.lang("gui.entity_filter.selected_attributes", new Object[0])).plainCopy().withStyle(ChatFormatting.YELLOW));
        ((EntityFilterMenu)this.menu).selectedAttributes.forEach(at -> this.selectedAttributes.add((Component)Component.literal((String)"- ").append(at.attribute().format(at.inverted())).withStyle(ChatFormatting.GRAY)));
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        int invX = this.getLeftOfCentered(AllGuiTextures.PLAYER_INVENTORY.getWidth());
        int invY = this.topPos + this.background.getHeight() + 4;
        this.renderPlayerInventory(graphics, invX, invY);
        int x = this.leftPos;
        int y = this.topPos;
        this.background.render(graphics, x, y);
        ((GuiGameElement.GuiRenderBuilder)GuiGameElement.of((ItemStack)((ItemStack)((EntityFilterMenu)this.menu).contentHolder)).at((float)(x + this.background.getWidth() + 8), (float)(y + this.background.getHeight() - 52), -200.0f)).scale(4.0).render(graphics);
    }

    private void referenceItemChanged(ItemStack stack) {
        this.lastItemScanned = stack;
        if (stack.isEmpty()) {
            this.attributeSelector.active = false;
            this.attributeSelector.visible = false;
            this.attributeSelectorLabel.text = CreateDieselGenerators.lang("gui.entity_filter.add_reference_item", new Object[0]).plainCopy().withStyle(ChatFormatting.ITALIC);
            this.add.active = false;
            this.addInverted.active = false;
            this.attributeSelector.calling(s -> {});
            return;
        }
        this.add.active = true;
        this.addInverted.active = true;
        this.attributeSelector.titled(stack.getHoverName().plainCopy().append("..."));
        this.attributesOfItem.clear();
        for (EntityAttribute entityAttribute : EntityAttribute.all) {
            this.attributesOfItem.addAll(entityAttribute.listAttributesOf(stack));
        }
        List options = this.attributesOfItem.stream().map(a -> a.format(false)).collect(Collectors.toList());
        this.attributeSelector.forOptions(options);
        this.attributeSelector.active = true;
        this.attributeSelector.visible = true;
        this.attributeSelector.setState(0);
        this.attributeSelector.calling(i -> {
            if (options.isEmpty()) {
                return;
            }
            this.attributeSelectorLabel.setTextAndTrim((Component)options.get((int)i), true, 112);
            EntityAttribute selected = this.attributesOfItem.get((int)i);
            for (EntityAttribute.EntityAttributeEntry existing : ((EntityFilterMenu)this.menu).selectedAttributes) {
                CompoundTag testTag2;
                CompoundTag testTag = existing.attribute().write();
                if (!testTag.equals((Object)(testTag2 = selected.write()))) continue;
                this.add.active = false;
                this.addInverted.active = false;
                return;
            }
            this.add.active = true;
            this.addInverted.active = true;
        });
        this.attributeSelector.onChanged();
    }

    protected boolean handleAddedAttribute(boolean inverted) {
        int index = this.attributeSelector.getState();
        if (index >= this.attributesOfItem.size()) {
            return false;
        }
        this.add.active = false;
        this.addInverted.active = false;
        EntityAttribute attribute = this.attributesOfItem.get(index);
        CatnipServices.NETWORK.sendToServer((CustomPacketPayload)new EntityFilterScreenPacket(inverted ? FilterScreenPacket.Option.ADD_INVERTED_TAG : FilterScreenPacket.Option.ADD_TAG, attribute));
        ((EntityFilterMenu)this.menu).appendSelectedAttribute(attribute, inverted);
        if (((EntityFilterMenu)this.menu).selectedAttributes.size() == 1) {
            this.selectedAttributes.set(0, (Component)CreateDieselGenerators.lang("gui.entity_filter.selected_attributes", new Object[0]).plainCopy().withStyle(ChatFormatting.YELLOW));
        }
        this.selectedAttributes.add((Component)Component.literal((String)"- ").append(attribute.format(inverted)).withStyle(ChatFormatting.GRAY));
        return true;
    }

    public void renderForeground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        ItemStack stack = ((EntityFilterMenu)this.menu).ghostInventory.getStackInSlot(1);
        PoseStack matrixStack = graphics.pose();
        matrixStack.pushPose();
        matrixStack.translate(0.0f, 0.0f, 150.0f);
        graphics.renderItemDecorations(this.font, stack, this.leftPos + 16, this.topPos + 62, String.valueOf(this.selectedAttributes.size() - 1));
        matrixStack.popPose();
        super.renderForeground(graphics, mouseX, mouseY, partialTicks);
    }

    protected void renderTooltip(GuiGraphics graphics, int mouseX, int mouseY) {
        if (((EntityFilterMenu)this.menu).getCarried().isEmpty() && this.hoveredSlot != null && this.hoveredSlot.hasItem()) {
            if (this.hoveredSlot.index == 37) {
                graphics.renderComponentTooltip(this.font, this.selectedAttributes, mouseX, mouseY);
                return;
            }
            graphics.renderTooltip(this.font, this.hoveredSlot.getItem(), mouseX, mouseY);
        }
        super.renderTooltip(graphics, mouseX, mouseY);
    }

    protected void containerTick() {
        super.containerTick();
        ItemStack stackInSlot = ((EntityFilterMenu)this.menu).ghostInventory.getStackInSlot(0);
        if (!ItemStack.isSameItemSameComponents((ItemStack)stackInSlot, (ItemStack)this.lastItemScanned)) {
            this.referenceItemChanged(stackInSlot);
        }
    }

    protected void contentsCleared() {
        this.selectedAttributes.clear();
        this.selectedAttributes.add((Component)CreateDieselGenerators.lang("gui.entity_filter.no_selected_attributes", new Object[0]).plainCopy().withStyle(ChatFormatting.YELLOW));
        if (!this.lastItemScanned.isEmpty()) {
            this.add.active = true;
            this.addInverted.active = true;
        }
    }

    protected boolean isButtonEnabled(IconButton button) {
        if (button == this.blacklist) {
            return ((EntityFilterMenu)this.menu).whitelistMode != AttributeFilterWhitelistMode.BLACKLIST;
        }
        if (button == this.whitelistCon) {
            return ((EntityFilterMenu)this.menu).whitelistMode != AttributeFilterWhitelistMode.WHITELIST_CONJ;
        }
        if (button == this.whitelistDis) {
            return ((EntityFilterMenu)this.menu).whitelistMode != AttributeFilterWhitelistMode.WHITELIST_DISJ;
        }
        return true;
    }

    protected List<IconButton> getTooltipButtons() {
        return Arrays.asList(this.blacklist, this.whitelistCon, this.whitelistDis);
    }

    protected List<MutableComponent> getTooltipDescriptions() {
        return Arrays.asList(CreateDieselGenerators.lang("gui.entity_filter.deny_list.description", new Object[0]).plainCopy(), CreateDieselGenerators.lang("gui.entity_filter.allow_list_conjunctive.description", new Object[0]).plainCopy(), CreateDieselGenerators.lang("gui.entity_filter.allow_list_disjunctive.description", new Object[0]).plainCopy());
    }

    protected void sendOptionUpdate(FilterScreenPacket.Option option) {
        CatnipServices.NETWORK.sendToServer((CustomPacketPayload)new EntityFilterScreenPacket(option, EntityAttribute.IS_MOB));
    }
}

