/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.content.track_layers_bag;

import com.jesz.createdieselgenerators.CDGDataComponents;
import com.jesz.createdieselgenerators.CDGItems;
import com.jesz.createdieselgenerators.CreateDieselGenerators;
import com.jesz.createdieselgenerators.content.track_layers_bag.TrackLayersBagComponent;
import com.jesz.createdieselgenerators.content.track_layers_bag.TrackLayersBagItemDataComponent;
import com.jesz.createdieselgenerators.mixins.UseOnContextInvoker;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.trains.track.TrackBlock;
import com.simibubi.create.content.trains.track.TrackBlockItem;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateItemModelProvider;
import java.util.Optional;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;

public class TrackLayersBagItem
extends Item {
    public TrackLayersBagItem(Item.Properties properties) {
        super(properties.stacksTo(1));
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        ItemStack track = TrackLayersBagItem.getTracks(stack);
        if (track.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new TrackLayersBagComponent(track));
    }

    int add(ItemStack bag, ItemStack stack) {
        if (!stack.isEmpty() && stack.getItem() instanceof TrackBlockItem) {
            ItemStack stackInBag = TrackLayersBagItem.getTracks(bag);
            if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)stackInBag) && !stackInBag.isEmpty()) {
                return 0;
            }
            int oldCount = stackInBag.getCount();
            if (stackInBag.isEmpty()) {
                stackInBag = stack.copy();
            } else {
                stackInBag.setCount(Math.min(oldCount + stack.getCount(), 1024));
            }
            bag.set(CDGDataComponents.TRACKS, (Object)new TrackLayersBagItemDataComponent(stackInBag));
            return Math.min(stack.getCount(), 1024 - oldCount);
        }
        return 0;
    }

    static ItemStack removeOne(ItemStack bag) {
        ItemStack stackInBag = TrackLayersBagItem.getTracks(bag);
        if (stackInBag.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack savedStack = stackInBag.copy();
        int amount = savedStack.getCount();
        savedStack.shrink(64);
        bag.set(CDGDataComponents.TRACKS, (Object)new TrackLayersBagItemDataComponent(savedStack));
        if (savedStack.getCount() == 0) {
            bag.remove(CDGDataComponents.TRACKS);
        }
        return stackInBag.copyWithCount(Math.min(amount, 64));
    }

    public int getBarWidth(ItemStack stack) {
        return 1 + (int)((float)TrackLayersBagItem.getTracks(stack).getCount() / 1024.0f * 12.0f);
    }

    public int getBarColor(ItemStack stack) {
        return 0x66FF66;
    }

    public boolean isBarVisible(ItemStack stack) {
        return TrackLayersBagItem.getTracks(stack).getCount() != 0;
    }

    public boolean overrideStackedOnOther(ItemStack stack, Slot slot, ClickAction click, Player player) {
        int added;
        if (stack.getCount() != 1 || click != ClickAction.SECONDARY) {
            return false;
        }
        ItemStack stackInSlot = slot.getItem();
        if (stackInSlot.isEmpty() && slot.mayPlace(TrackLayersBagItem.getTracks(stack))) {
            player.playSound(SoundEvents.BUNDLE_REMOVE_ONE, 0.8f, 0.8f + player.level().getRandom().nextFloat() * 0.4f);
            slot.set(TrackLayersBagItem.removeOne(stack));
        } else if (!stackInSlot.isEmpty() && slot.mayPickup(player) && (added = this.add(stack, stackInSlot)) > 0) {
            player.playSound(SoundEvents.BUNDLE_INSERT, 0.8f, 0.8f + player.level().getRandom().nextFloat() * 0.4f);
            stackInSlot.shrink(added);
        }
        return true;
    }

    public boolean overrideOtherStackedOnMe(ItemStack bag, ItemStack otherStack, Slot slot, ClickAction click, Player player, SlotAccess slotAccess) {
        if (bag.getCount() != 1 || click != ClickAction.SECONDARY || !slot.allowModification(player)) {
            return false;
        }
        if (otherStack.isEmpty()) {
            ItemStack extractedStack = TrackLayersBagItem.removeOne(bag);
            if (!extractedStack.isEmpty()) {
                player.playSound(SoundEvents.BUNDLE_REMOVE_ONE, 0.8f, 0.8f + player.level().getRandom().nextFloat() * 0.4f);
                slotAccess.set(extractedStack);
            }
        } else {
            int added = this.add(bag, otherStack);
            if (added > 0) {
                player.playSound(SoundEvents.BUNDLE_INSERT, 0.8f, 0.8f + player.level().getRandom().nextFloat() * 0.4f);
                otherStack.shrink(added);
            }
        }
        return true;
    }

    public static ItemStack getTracks(ItemStack stack) {
        TrackLayersBagItemDataComponent component = (TrackLayersBagItemDataComponent)stack.get(CDGDataComponents.TRACKS);
        ItemStack trackStack = component == null ? ItemStack.EMPTY : component.stack().copyWithCount(component.count());
        return trackStack;
    }

    public InteractionResult useOn(UseOnContext context) {
        ItemStack stack = context.getItemInHand();
        ItemStack tracks = TrackLayersBagItem.getTracks(stack);
        if (tracks.isEmpty()) {
            return super.useOn(context);
        }
        BlockState clickedState = context.getLevel().getBlockState(context.getClickedPos());
        if (!(clickedState.getBlock() instanceof TrackBlock)) {
            stack.set(CDGDataComponents.TRACKS, (Object)new TrackLayersBagItemDataComponent(tracks.copyWithCount(Math.max(0, tracks.getCount() - 1))));
            return ((TrackBlockItem)tracks.getItem()).place(new BlockPlaceContext(context.getLevel(), context.getPlayer(), context.getHand(), tracks, ((UseOnContextInvoker)context).cdg_getHitResult()));
        }
        return InteractionResult.SUCCESS;
    }

    private InteractionResult place(BlockPlaceContext context, BlockItem item) {
        CollisionContext collision;
        if (!context.canPlace()) {
            return InteractionResult.FAIL;
        }
        BlockPos pos = context.getClickedPos();
        Level level = context.getLevel();
        Player player = context.getPlayer();
        BlockState blockstate = item.getBlock().getStateForPlacement(context);
        CollisionContext collisionContext = collision = player == null ? CollisionContext.empty() : CollisionContext.of((Entity)player);
        if (!blockstate.canSurvive((LevelReader)level, pos) || !level.isUnobstructed(blockstate, pos, collision)) {
            return InteractionResult.FAIL;
        }
        if (!level.setBlock(pos, blockstate, 11)) {
            return InteractionResult.FAIL;
        }
        BlockState clickedState = level.getBlockState(pos);
        level.gameEvent((Holder)GameEvent.BLOCK_PLACE, pos, GameEvent.Context.of((Entity)player, (BlockState)clickedState));
        SoundType sound = clickedState.getSoundType((LevelReader)level, pos, (Entity)context.getPlayer());
        level.playSound(player, pos, clickedState.getSoundType().getPlaceSound(), SoundSource.BLOCKS, (sound.getVolume() + 1.0f) / 2.0f, sound.getPitch() * 0.8f);
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public void registerModelOverrides() {
        CatnipServices.PLATFORM.executeOnClientOnly(() -> () -> ItemProperties.register((Item)((Item)CDGItems.TRACK_LAYERS_BAG.get()), (ResourceLocation)CreateDieselGenerators.rl("tracks"), (stack, level, entity, seed) -> TrackLayersBagItem.getTracks(stack).getCount()));
    }

    public static ItemModelBuilder addOverrideModels(DataGenContext<Item, TrackLayersBagItem> c, RegistrateItemModelProvider p) {
        ItemModelBuilder builder = p.generated(() -> (ItemLike)c.get());
        builder.override().predicate(CreateDieselGenerators.rl("tracks"), 0.01f).model((ModelFile)((ItemModelBuilder)((ItemModelBuilder)p.getBuilder(c.getName() + "_filled")).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", CreateDieselGenerators.rl("item/track_layers_bag_filled"))).end();
        return builder;
    }

    public static ItemStack full() {
        ItemStack stack = CDGItems.TRACK_LAYERS_BAG.asStack();
        ((TrackLayersBagItem)stack.getItem()).add(stack, AllBlocks.TRACK.asStack(1024));
        return stack;
    }
}

