/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.contraption;

import com.jesz.createdieselgenerators.CDGBlocks;
import com.jesz.createdieselgenerators.CDGConfig;
import com.jesz.createdieselgenerators.CDGSoundEvents;
import com.jesz.createdieselgenerators.content.diesel_engine.EngineSoundInstance;
import com.simibubi.create.api.behaviour.movement.MovementBehaviour;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.trains.entity.CarriageContraption;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import it.unimi.dsi.fastutil.Pair;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class DieselEngineMovementBehaviour
implements MovementBehaviour {
    @OnlyIn(value=Dist.CLIENT)
    static Map<Pair<UUID, BlockPos>, EngineSoundInstance> soundInstances;

    public boolean isActive(MovementContext context) {
        return context.contraption instanceof CarriageContraption && super.isActive(context);
    }

    @Nullable
    public ItemStack canBeDisabledVia(MovementContext context) {
        return CDGBlocks.DIESEL_ENGINE.asStack();
    }

    public void tick(MovementContext context) {
        if (!context.world.isClientSide) {
            return;
        }
        CatnipServices.PLATFORM.executeOnClientOnly(() -> () -> this.clientTick(context));
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void clientTick(MovementContext context) {
        CarriageContraption contraption = (CarriageContraption)context.contraption;
        CarriageContraptionEntity entity = (CarriageContraptionEntity)contraption.entity;
        if (soundInstances == null) {
            soundInstances = new HashMap<Pair<UUID, BlockPos>, EngineSoundInstance>();
        }
        if (!((Boolean)CDGConfig.ENGINES_EMIT_SOUND_ON_TRAINS.get()).booleanValue() || entity.getCarriage().train.derailed) {
            return;
        }
        double trainSpeed = context.motion.length() * 2.0 / (double)(entity.getCarriage().train.maxSpeed() / 28.0f);
        double lastTrainSpeed = context.data.getDouble("TrainSpeed");
        double acceleration = trainSpeed - lastTrainSpeed;
        context.data.putDouble("TrainSpeed", trainSpeed);
        float throttle = Mth.lerp((float)0.05f, (float)context.data.getFloat("Throttle"), (float)((float)Math.max(0.0, Math.min(1.0, acceleration))));
        context.data.putFloat("Throttle", throttle);
        EngineSoundInstance instance = soundInstances.get(Pair.of((Object)entity.getUUID(), (Object)context.localPos));
        if (context.disabled) {
            if (instance != null) {
                instance.fadeOut();
            }
            return;
        }
        if (instance == null) {
            instance = new EngineSoundInstance((SoundEvent)CDGSoundEvents.ENGINE_NORMAL.get(), SoundSource.NEUTRAL, context.position, 0.6f);
            instance.setVolume(1.0f);
            Minecraft.getInstance().getSoundManager().play((SoundInstance)instance);
            soundInstances.put((Pair<UUID, BlockPos>)Pair.of((Object)entity.getUUID(), (Object)context.localPos), instance);
        } else if (instance.isStopped()) {
            soundInstances.remove(Pair.of((Object)entity.getUUID(), (Object)context.localPos));
        }
        instance.setPosition(context.position);
        if (instance.active()) {
            instance.keepAlive();
            float pitch = (float)Math.min(2.0, Math.max(Math.min(0.14, (double)throttle) * 5.0 + trainSpeed / 28.0, (double)0.1f));
            instance.setPitch(pitch);
        }
    }
}

