/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.fuel_type;

import com.jesz.createdieselgenerators.content.diesel_engine.EngineTypes;
import com.jesz.createdieselgenerators.content.diesel_engine.huge.HugeDieselEngineBlockEntity;
import com.jesz.createdieselgenerators.content.diesel_engine.modular.ModularDieselEngineBlockEntity;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;

public record FuelType(HolderSet<Fluid> fluid, PerEngineProperties normal, PerEngineProperties modular, PerEngineProperties huge, float soundPitch, float burnerStrength) {
    public static final Codec<FuelType> CODEC = RecordCodecBuilder.create(i -> i.group((App)RegistryCodecs.homogeneousList((ResourceKey)Registries.FLUID).fieldOf("fluid").forGetter(FuelType::fluid), (App)PerEngineProperties.CODEC.fieldOf("normal").forGetter(FuelType::normal), (App)PerEngineProperties.CODEC.fieldOf("modular").forGetter(FuelType::modular), (App)PerEngineProperties.CODEC.fieldOf("huge").forGetter(FuelType::huge), (App)Codec.FLOAT.optionalFieldOf("sound_pitch", (Object)Float.valueOf(1.0f)).forGetter(FuelType::soundPitch), (App)Codec.FLOAT.optionalFieldOf("burner_multiplier", (Object)Float.valueOf(1.0f)).forGetter(FuelType::burnerStrength)).apply((Applicative)i, FuelType::new));
    public static final Codec<FuelType> NCODEC = RecordCodecBuilder.create(i -> i.group((App)RegistryCodecs.homogeneousList((ResourceKey)Registries.FLUID).fieldOf("fluid").forGetter(type -> HolderSet.direct(type.fluid.stream().toList())), (App)PerEngineProperties.CODEC.fieldOf("normal").forGetter(FuelType::normal), (App)PerEngineProperties.CODEC.fieldOf("modular").forGetter(FuelType::modular), (App)PerEngineProperties.CODEC.fieldOf("huge").forGetter(FuelType::huge), (App)Codec.FLOAT.optionalFieldOf("sound_pitch", (Object)Float.valueOf(1.0f)).forGetter(FuelType::soundPitch), (App)Codec.FLOAT.optionalFieldOf("burner_multiplier", (Object)Float.valueOf(1.0f)).forGetter(FuelType::burnerStrength)).apply((Applicative)i, FuelType::new));
    public static final FuelType EMPTY = new FuelType(null, new PerEngineProperties(0.0f, 0.0f, 0.0f), new PerEngineProperties(0.0f, 0.0f, 0.0f), new PerEngineProperties(0.0f, 0.0f, 0.0f), 0.0f, 0.0f);

    public PerEngineProperties getGenerated(BlockEntity be) {
        if (be instanceof HugeDieselEngineBlockEntity) {
            return this.huge;
        }
        if (be instanceof ModularDieselEngineBlockEntity) {
            return this.modular;
        }
        return this.normal;
    }

    public static FuelType getTypeFor(HolderLookup.RegistryLookup<FuelType> registry, Fluid fluid) {
        if (registry == null) {
            return EMPTY;
        }
        Optional<Holder.Reference> type = registry.listElements().filter(r -> ((FuelType)r.value()).fluid().contains((Holder)fluid.builtInRegistryHolder())).findFirst();
        return type.isEmpty() ? EMPTY : (FuelType)type.get().value();
    }

    public PerEngineProperties getGenerated(EngineTypes currentEngine) {
        if (currentEngine == EngineTypes.HUGE) {
            return this.huge;
        }
        if (currentEngine == EngineTypes.MODULAR) {
            return this.modular;
        }
        return this.normal;
    }

    public record PerEngineProperties(float speed, float strength, float burn) {
        public static final Codec<PerEngineProperties> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.FLOAT.fieldOf("speed").forGetter(PerEngineProperties::speed), (App)Codec.FLOAT.fieldOf("strength").forGetter(PerEngineProperties::strength), (App)Codec.FLOAT.fieldOf("burn_rate").forGetter(PerEngineProperties::burn)).apply((Applicative)i, PerEngineProperties::new));
    }
}

